/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.metadata;

import javax.management.DynamicMBean;
import javax.management.MBean;
import javax.management.NotCompliantMBeanException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanCapability {
    public static final int DYNAMIC_MBEAN = 801;
    public static final int STANDARD_MBEAN = 291;
    public static final int NOT_AN_MBEAN = 49374;

    private MBeanCapability() {
    }

    public static int of(Class<?> mbeanClass) throws NotCompliantMBeanException {
        Class<?>[] interfaces;
        if (null == mbeanClass) {
            throw new IllegalArgumentException("MBean class cannot be null");
        }
        if (DynamicMBean.class.isAssignableFrom(mbeanClass)) {
            return 801;
        }
        if (mbeanClass.isAnnotationPresent(MBean.class)) {
            return 291;
        }
        for (Class<?> anInterface : interfaces = mbeanClass.getInterfaces()) {
            if (!anInterface.getName().equals(mbeanClass.getName() + "MBean")) continue;
            return 291;
        }
        Class<?> superClass = mbeanClass.getSuperclass();
        if (superClass != null) {
            return MBeanCapability.of(superClass);
        }
        throw new NotCompliantMBeanException("Class does not expose a management interface: " + mbeanClass.getName());
    }
}

