/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.File;
import java.util.Set;
import org.jboss.seam.deployment.DeploymentStrategy;
import org.jboss.seam.deployment.DotPageDotXmlDeploymentHandler;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarRootDeploymentStrategy
extends DeploymentStrategy {
    private static LogProvider log = Logging.getLogProvider(WarRootDeploymentStrategy.class);
    private ClassLoader classLoader;
    private File[] warRoot;
    public static final String HANDLERS_KEY = "org.jboss.seam.deployment.deploymentHandlers";
    public static final String NAME = "warRootDeploymentStrategy";
    private DotPageDotXmlDeploymentHandler dotPageDotXmlDeploymentHandler;

    public WarRootDeploymentStrategy(ClassLoader classLoader, File warRoot) {
        this.classLoader = classLoader;
        this.warRoot = new File[1];
        if (warRoot != null) {
            this.warRoot[0] = warRoot;
        } else {
            log.warn("Unable to discover war root, .page.xml files won't be found");
            this.warRoot = new File[0];
        }
        this.dotPageDotXmlDeploymentHandler = new DotPageDotXmlDeploymentHandler();
        this.getDeploymentHandlers().put("org.jboss.seam.deployment.DotPageDotXmlDeploymentHandler", this.dotPageDotXmlDeploymentHandler);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    protected String getDeploymentHandlersKey() {
        return HANDLERS_KEY;
    }

    @Override
    public void handle(String name) {
        if (!name.startsWith("WEB-INF") && !name.startsWith("/WEB-INF")) {
            super.handle(name);
        }
    }

    @Override
    public void scan() {
        this.getScanner().scanDirectories(this.warRoot);
    }

    public Set<String> getDotPageDotXmlFileNames() {
        return this.dotPageDotXmlDeploymentHandler.getFiles();
    }
}

