/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Set;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.deployment.AnnotationDeploymentHandler;
import org.jboss.seam.deployment.ComponentDeploymentHandler;
import org.jboss.seam.deployment.DeploymentStrategy;
import org.jboss.seam.deployment.DotPageDotXmlDeploymentHandler;
import org.jboss.seam.deployment.SeamDeploymentProperties;
import org.jboss.seam.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HotDeploymentStrategy
extends DeploymentStrategy {
    public static final String DEFAULT_HOT_DEPLOYMENT_DIRECTORY_PATH = "/WEB-INF/dev";
    public static final String NAME = "hotDeploymentStrategy";
    public static final String HANDLERS_KEY = "org.jboss.seam.deployment.hotDeploymentHandlers";
    private ClassLoader hotDeployClassLoader;
    private ComponentDeploymentHandler componentDeploymentHandler;
    private AnnotationDeploymentHandler annotationDeploymentHandler;
    private ClassLoader classLoader;

    public HotDeploymentStrategy(ClassLoader classLoader, File hotDeployDirectory, boolean enabled) {
        if (enabled) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
            if (hotDeployDirectory != null && hotDeployDirectory.exists()) {
                this.initHotDeployClassLoader(classLoader, hotDeployDirectory);
                this.componentDeploymentHandler = new ComponentDeploymentHandler();
                this.getDeploymentHandlers().put("org.jboss.seam.deployment.ComponentDeploymentHandler", this.componentDeploymentHandler);
                this.annotationDeploymentHandler = new AnnotationDeploymentHandler(new SeamDeploymentProperties(classLoader).getPropertyValues("org.jboss.seam.deployment.annotationTypes"), classLoader);
                this.getDeploymentHandlers().put("org.jboss.seam.deployment.AnnotationDeploymentHandler", this.annotationDeploymentHandler);
            }
            this.getDeploymentHandlers().put("org.jboss.seam.deployment.DotPageDotXmlDeploymentHandler", new DotPageDotXmlDeploymentHandler());
        }
    }

    private void initHotDeployClassLoader(ClassLoader classLoader, File hotDeployDirectory) {
        try {
            URL url = hotDeployDirectory.toURL();
            URL[] urls = new URL[]{url};
            this.hotDeployClassLoader = new URLClassLoader(urls, classLoader);
            this.getFiles().add(hotDeployDirectory);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue);
        }
    }

    public boolean isEnabled() {
        return this.classLoader != null;
    }

    public boolean isHotDeployClassLoaderEnabled() {
        return this.hotDeployClassLoader != null;
    }

    @Override
    protected String getDeploymentHandlersKey() {
        return HANDLERS_KEY;
    }

    public File[] getHotDeploymentPaths() {
        return this.getFiles().toArray(new File[0]);
    }

    public boolean isFromHotDeployClassLoader(Class componentClass) {
        return componentClass.getClassLoader() == this.hotDeployClassLoader;
    }

    public static HotDeploymentStrategy createInstance(String className, ClassLoader classLoader, File hotDeployDirectory, boolean enabled) {
        try {
            Class initializer = Reflections.classForName(className);
            Constructor ctr = initializer.getConstructor(ClassLoader.class, File.class, Boolean.TYPE);
            return (HotDeploymentStrategy)ctr.newInstance(classLoader, hotDeployDirectory, enabled);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No such deployment strategy " + className, e);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.hotDeployClassLoader != null ? this.hotDeployClassLoader : this.classLoader;
    }

    public Set<Class<Object>> getScannedComponentClasses() {
        return this.componentDeploymentHandler.getClasses();
    }

    public Map<String, Set<Class<Object>>> getAnnotatedClasses() {
        return this.annotationDeploymentHandler.getClasses();
    }

    @Override
    public void scan() {
        this.getScanner().scanDirectories(this.getFiles().toArray(new File[0]));
    }

    public static HotDeploymentStrategy instance() {
        if (Contexts.getEventContext().isSet(NAME)) {
            return (HotDeploymentStrategy)Contexts.getEventContext().get(NAME);
        }
        return null;
    }
}

