/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb.json;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.jboss.resteasy.plugins.providers.jaxb.AbstractJAXBProvider;
import org.jboss.resteasy.plugins.providers.jaxb.CollectionProvider;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBContextFinder;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBMarshalException;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBUnmarshalException;
import org.jboss.resteasy.plugins.providers.jaxb.json.JsonParsing;
import org.jboss.resteasy.util.Types;

@Provider
@Produces(value={"application/*+json"})
@Consumes(value={"application/*+json"})
public class JsonCollectionProvider
extends CollectionProvider {
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Class baseType = Types.getCollectionBaseType(type, (Type)genericType);
        BufferedReader reader = null;
        String charset = (String)mediaType.getParameters().get("charset");
        reader = charset != null ? new BufferedReader(new InputStreamReader(entityStream, charset)) : new BufferedReader(new InputStreamReader(entityStream));
        char c = JsonParsing.eatWhitspace(reader, false);
        if (c != '[') {
            throw new JAXBUnmarshalException("Expecting a json array as input");
        }
        c = JsonParsing.eatWhitspace(reader, true);
        ArrayList<Object> list = new ArrayList<Object>();
        if (c != ']') {
            MessageBodyReader messageReader = this.providers.getMessageBodyReader(baseType, null, annotations, mediaType);
            do {
                String str = JsonParsing.extractJsonMapString(reader);
                ByteArrayInputStream stream = new ByteArrayInputStream(str.getBytes());
                Object obj = messageReader.readFrom(baseType, null, annotations, mediaType, httpHeaders, (InputStream)stream);
                list.add(obj);
                c = JsonParsing.eatWhitspace(reader, false);
                if (c == ']') break;
                if (c == ',') continue;
                throw new JAXBUnmarshalException("Was expecting a ',' in json array");
            } while ((c = JsonParsing.eatWhitspace(reader, true)) != '\uffffffff');
        }
        if (type.isArray()) {
            Object array = Array.newInstance(baseType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(array, i, list.get(i));
            }
            return array;
        }
        AbstractCollection outCol = null;
        if (type.isInterface()) {
            if (List.class.isAssignableFrom(type)) {
                return list;
            }
            outCol = Set.class.isAssignableFrom(type) ? new HashSet() : new ArrayList();
        } else {
            try {
                outCol = (HashSet)type.newInstance();
            }
            catch (Exception e) {
                throw new JAXBUnmarshalException((Throwable)e);
            }
        }
        outCol.addAll(list);
        return outCol;
    }

    public void writeTo(Object entry, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JAXBContextFinder finder = this.getFinder(mediaType);
        if (finder == null) {
            throw new JAXBMarshalException("Unable to find JAXBContext for media type: " + mediaType);
        }
        Class baseType = Types.getCollectionBaseType(type, (Type)genericType);
        entityStream.write(91);
        try {
            JAXBContext ctx = finder.findCachedContext(baseType, mediaType, annotations);
            Marshaller marshaller = ctx.createMarshaller();
            marshaller = AbstractJAXBProvider.decorateMarshaller((Class)baseType, (Annotation[])annotations, (MediaType)mediaType, (Marshaller)marshaller);
            if (type.isArray()) {
                Object[] array = (Object[])entry;
                boolean first = true;
                for (Object obj : array) {
                    if (first) {
                        first = false;
                    } else {
                        entityStream.write(44);
                    }
                    marshaller.marshal(obj, entityStream);
                }
            } else {
                Collection collection = (Collection)entry;
                boolean first = true;
                for (Object obj : collection) {
                    if (first) {
                        first = false;
                    } else {
                        entityStream.write(44);
                    }
                    marshaller.marshal(obj, entityStream);
                }
            }
            entityStream.write(93);
        }
        catch (JAXBException e) {
            throw new JAXBMarshalException((Throwable)e);
        }
    }
}

