/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.Pair;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.AbstractJournalUpdateTask;
import org.hornetq.core.journal.impl.JournalFile;
import org.hornetq.core.journal.impl.JournalFileImpl;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.journal.impl.JournalReaderCallbackAbstract;
import org.hornetq.core.journal.impl.JournalRecord;
import org.hornetq.core.journal.impl.JournalRecordProvider;
import org.hornetq.core.journal.impl.JournalTransaction;
import org.hornetq.core.journal.impl.dataformat.ByteArrayEncoding;
import org.hornetq.core.journal.impl.dataformat.JournalAddRecord;
import org.hornetq.core.journal.impl.dataformat.JournalAddRecordTX;
import org.hornetq.core.journal.impl.dataformat.JournalCompleteRecordTX;
import org.hornetq.core.journal.impl.dataformat.JournalDeleteRecordTX;
import org.hornetq.core.journal.impl.dataformat.JournalInternalRecord;
import org.hornetq.core.journal.impl.dataformat.JournalRollbackRecordTX;
import org.hornetq.core.logging.Logger;

public class JournalCompactor
extends AbstractJournalUpdateTask
implements JournalRecordProvider {
    private static final Logger log = Logger.getLogger(JournalCompactor.class);
    private final Map<Long, PendingTransaction> pendingTransactions = new ConcurrentHashMap<Long, PendingTransaction>();
    private final Map<Long, JournalRecord> newRecords = new HashMap<Long, JournalRecord>();
    private final Map<Long, JournalTransaction> newTransactions = new HashMap<Long, JournalTransaction>();
    private final LinkedList<CompactCommand> pendingCommands = new LinkedList();

    public static SequentialFile readControlFile(SequentialFileFactory fileFactory, List<String> dataFiles, List<String> newFiles, List<Pair<String, String>> renameFile) throws Exception {
        SequentialFile controlFile = fileFactory.createSequentialFile("journal-rename-control.ctr", 1);
        if (controlFile.exists()) {
            JournalFileImpl file = new JournalFileImpl(controlFile, 0L);
            final ArrayList records = new ArrayList();
            JournalImpl.readJournalFile(fileFactory, file, new JournalReaderCallbackAbstract(){

                @Override
                public void onReadAddRecord(RecordInfo info) throws Exception {
                    records.add(info);
                }
            });
            if (records.size() == 0) {
                return null;
            }
            HornetQBuffer input = HornetQBuffers.wrappedBuffer(((RecordInfo)records.get((int)0)).data);
            int numberDataFiles = input.readInt();
            for (int i = 0; i < numberDataFiles; ++i) {
                dataFiles.add(input.readUTF());
            }
            int numberNewFiles = input.readInt();
            for (int i = 0; i < numberNewFiles; ++i) {
                newFiles.add(input.readUTF());
            }
            int numberRenames = input.readInt();
            for (int i = 0; i < numberRenames; ++i) {
                String from = input.readUTF();
                String to = input.readUTF();
                renameFile.add(new Pair<String, String>(from, to));
            }
            return controlFile;
        }
        return null;
    }

    public List<JournalFile> getNewDataFiles() {
        return this.newDataFiles;
    }

    public Map<Long, JournalRecord> getNewRecords() {
        return this.newRecords;
    }

    public Map<Long, JournalTransaction> getNewTransactions() {
        return this.newTransactions;
    }

    public JournalCompactor(SequentialFileFactory fileFactory, JournalImpl journal, Set<Long> recordsSnapshot, long firstFileID) {
        super(fileFactory, journal, recordsSnapshot, firstFileID);
    }

    public void addPendingTransaction(long transactionID, long[] ids) {
        this.pendingTransactions.put(transactionID, new PendingTransaction(ids));
    }

    public void addCommandCommit(JournalTransaction liveTransaction, JournalFile currentFile) {
        this.pendingCommands.add(new CommitCompactCommand(liveTransaction, currentFile));
        long[] ids = liveTransaction.getPositiveArray();
        PendingTransaction oldTransaction = this.pendingTransactions.get(liveTransaction.getId());
        long[] ids2 = null;
        if (oldTransaction != null) {
            ids2 = oldTransaction.pendingIDs;
        }
        if (ids != null) {
            for (long id : ids) {
                this.addToRecordsSnaptshot(id);
            }
        }
        if (ids2 != null) {
            for (long id : ids2) {
                this.addToRecordsSnaptshot(id);
            }
        }
    }

    public void addCommandRollback(JournalTransaction liveTransaction, JournalFile currentFile) {
        this.pendingCommands.add(new RollbackCompactCommand(liveTransaction, currentFile));
    }

    public void addCommandDelete(long id, JournalFile usedFile) {
        this.pendingCommands.add(new DeleteCompactCommand(id, usedFile));
    }

    public void addCommandUpdate(long id, JournalFile usedFile, int size) {
        this.pendingCommands.add(new UpdateCompactCommand(id, usedFile, size));
    }

    private void checkSize(int size) throws Exception {
        if (this.getWritingChannel() == null) {
            this.openFile();
        } else if (this.getWritingChannel().writerIndex() + size > this.getWritingChannel().capacity()) {
            this.openFile();
        }
    }

    public void replayPendingCommands() {
        for (CompactCommand command : this.pendingCommands) {
            try {
                command.execute();
            }
            catch (Exception e) {
                log.warn("Error replaying pending commands after compacting", e);
            }
        }
        this.pendingCommands.clear();
    }

    @Override
    public void onReadAddRecord(RecordInfo info) throws Exception {
        if (this.lookupRecord(info.id)) {
            JournalAddRecord addRecord = new JournalAddRecord(true, info.id, info.getUserRecordType(), new ByteArrayEncoding(info.data));
            this.checkSize(((JournalInternalRecord)addRecord).getEncodeSize());
            this.writeEncoder(addRecord);
            this.newRecords.put(info.id, new JournalRecord(this.currentFile, ((JournalInternalRecord)addRecord).getEncodeSize()));
        }
    }

    @Override
    public void onReadAddRecordTX(long transactionID, RecordInfo info) throws Exception {
        if (this.pendingTransactions.get(transactionID) != null || this.lookupRecord(info.id)) {
            JournalTransaction newTransaction = this.getNewJournalTransaction(transactionID);
            JournalAddRecordTX record = new JournalAddRecordTX(true, transactionID, info.id, info.getUserRecordType(), new ByteArrayEncoding(info.data));
            this.checkSize(((JournalInternalRecord)record).getEncodeSize());
            newTransaction.addPositive(this.currentFile, info.id, ((JournalInternalRecord)record).getEncodeSize());
            this.writeEncoder(record);
        }
    }

    @Override
    public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
        if (this.pendingTransactions.get(transactionID) != null) {
            throw new IllegalStateException("Inconsistency during compacting: CommitRecord ID = " + transactionID + " for an already committed transaction during compacting");
        }
        JournalTransaction newTransaction = this.newTransactions.remove(transactionID);
        if (newTransaction != null) {
            JournalCompleteRecordTX commitRecord = new JournalCompleteRecordTX(true, transactionID, null);
            this.checkSize(((JournalInternalRecord)commitRecord).getEncodeSize());
            this.writeEncoder(commitRecord, newTransaction.getCounter(this.currentFile));
            newTransaction.commit(this.currentFile);
        }
    }

    @Override
    public void onReadDeleteRecord(long recordID) throws Exception {
        if (this.newRecords.get(recordID) != null) {
            throw new IllegalStateException("Inconsistency during compacting: Delete record being read on an existent record (id=" + recordID + ")");
        }
    }

    @Override
    public void onReadDeleteRecordTX(long transactionID, RecordInfo info) throws Exception {
        if (this.pendingTransactions.get(transactionID) != null) {
            JournalTransaction newTransaction = this.getNewJournalTransaction(transactionID);
            JournalDeleteRecordTX record = new JournalDeleteRecordTX(transactionID, info.id, new ByteArrayEncoding(info.data));
            this.checkSize(((JournalInternalRecord)record).getEncodeSize());
            this.writeEncoder(record);
            newTransaction.addNegative(this.currentFile, info.id);
        }
    }

    @Override
    public void markAsDataFile(JournalFile file) {
    }

    @Override
    public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
        if (this.pendingTransactions.get(transactionID) != null) {
            JournalTransaction newTransaction = this.getNewJournalTransaction(transactionID);
            JournalCompleteRecordTX prepareRecord = new JournalCompleteRecordTX(false, transactionID, new ByteArrayEncoding(extraData));
            this.checkSize(((JournalInternalRecord)prepareRecord).getEncodeSize());
            this.writeEncoder(prepareRecord, newTransaction.getCounter(this.currentFile));
            newTransaction.prepare(this.currentFile);
        }
    }

    @Override
    public void onReadRollbackRecord(long transactionID) throws Exception {
        if (this.pendingTransactions.get(transactionID) != null) {
            throw new IllegalStateException("Inconsistency during compacting: RollbackRecord ID = " + transactionID + " for an already rolled back transaction during compacting");
        }
        JournalTransaction newTransaction = this.newTransactions.remove(transactionID);
        if (newTransaction != null) {
            JournalRollbackRecordTX rollbackRecord = new JournalRollbackRecordTX(transactionID);
            this.checkSize(((JournalInternalRecord)rollbackRecord).getEncodeSize());
            this.writeEncoder(rollbackRecord);
            newTransaction.rollback(this.currentFile);
        }
    }

    @Override
    public void onReadUpdateRecord(RecordInfo info) throws Exception {
        if (this.lookupRecord(info.id)) {
            JournalAddRecord updateRecord = new JournalAddRecord(false, info.id, info.userRecordType, new ByteArrayEncoding(info.data));
            this.checkSize(((JournalInternalRecord)updateRecord).getEncodeSize());
            JournalRecord newRecord = this.newRecords.get(info.id);
            if (newRecord == null) {
                log.warn("Couldn't find addRecord information for record " + info.id + " during compacting");
            } else {
                newRecord.addUpdateFile(this.currentFile, ((JournalInternalRecord)updateRecord).getEncodeSize());
            }
            this.writeEncoder(updateRecord);
        }
    }

    @Override
    public void onReadUpdateRecordTX(long transactionID, RecordInfo info) throws Exception {
        if (this.pendingTransactions.get(transactionID) != null || this.lookupRecord(info.id)) {
            JournalTransaction newTransaction = this.getNewJournalTransaction(transactionID);
            JournalAddRecordTX updateRecordTX = new JournalAddRecordTX(false, transactionID, info.id, info.userRecordType, new ByteArrayEncoding(info.data));
            this.checkSize(((JournalInternalRecord)updateRecordTX).getEncodeSize());
            this.writeEncoder(updateRecordTX);
            newTransaction.addPositive(this.currentFile, info.id, ((JournalInternalRecord)updateRecordTX).getEncodeSize());
        } else {
            this.onReadUpdateRecord(info);
        }
    }

    private JournalTransaction getNewJournalTransaction(long transactionID) {
        JournalTransaction newTransaction = this.newTransactions.get(transactionID);
        if (newTransaction == null) {
            newTransaction = new JournalTransaction(transactionID, this);
            this.newTransactions.put(transactionID, newTransaction);
        }
        return newTransaction;
    }

    @Override
    public JournalCompactor getCompactor() {
        return null;
    }

    @Override
    public Map<Long, JournalRecord> getRecords() {
        return this.newRecords;
    }

    private class RollbackCompactCommand
    extends CompactCommand {
        private final JournalTransaction liveTransaction;
        private final JournalFile rollbackFile;

        public RollbackCompactCommand(JournalTransaction liveTransaction, JournalFile rollbackFile) {
            this.liveTransaction = liveTransaction;
            this.rollbackFile = rollbackFile;
        }

        @Override
        void execute() throws Exception {
            JournalTransaction newTransaction = (JournalTransaction)JournalCompactor.this.newTransactions.get(this.liveTransaction.getId());
            if (newTransaction != null) {
                this.liveTransaction.merge(newTransaction);
                this.liveTransaction.rollback(this.rollbackFile);
            }
            JournalCompactor.this.newTransactions.remove(this.liveTransaction.getId());
        }
    }

    private class CommitCompactCommand
    extends CompactCommand {
        private final JournalTransaction liveTransaction;
        private final JournalFile commitFile;

        public CommitCompactCommand(JournalTransaction liveTransaction, JournalFile commitFile) {
            this.liveTransaction = liveTransaction;
            this.commitFile = commitFile;
        }

        @Override
        void execute() throws Exception {
            JournalTransaction newTransaction = (JournalTransaction)JournalCompactor.this.newTransactions.get(this.liveTransaction.getId());
            if (newTransaction != null) {
                this.liveTransaction.merge(newTransaction);
                this.liveTransaction.commit(this.commitFile);
            }
            JournalCompactor.this.newTransactions.remove(this.liveTransaction.getId());
        }
    }

    private class UpdateCompactCommand
    extends CompactCommand {
        private final long id;
        private final JournalFile usedFile;
        private final int size;

        public UpdateCompactCommand(long id, JournalFile usedFile, int size) {
            this.id = id;
            this.usedFile = usedFile;
            this.size = size;
        }

        @Override
        void execute() throws Exception {
            JournalRecord updateRecord = JournalCompactor.this.journal.getRecords().get(this.id);
            updateRecord.addUpdateFile(this.usedFile, this.size);
        }
    }

    private static class PendingTransaction {
        long[] pendingIDs;

        PendingTransaction(long[] ids) {
            this.pendingIDs = ids;
        }
    }

    private class DeleteCompactCommand
    extends CompactCommand {
        long id;
        JournalFile usedFile;

        public DeleteCompactCommand(long id, JournalFile usedFile) {
            this.id = id;
            this.usedFile = usedFile;
        }

        @Override
        void execute() throws Exception {
            JournalRecord deleteRecord = JournalCompactor.this.journal.getRecords().remove(this.id);
            deleteRecord.delete(this.usedFile);
        }
    }

    private static abstract class CompactCommand {
        private CompactCommand() {
        }

        abstract void execute() throws Exception;
    }
}

