/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.ejb.EJBTransactionRolledbackException;
import org.jboss.aop.Advisor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.tx.AbstractInterceptor;
import org.jboss.ejb3.tx.api.TransactionRetry;

public class RetryingInterceptor
extends AbstractInterceptor {
    protected <A extends Annotation> A getAnnotation(Invocation invocation, Method method, Class<A> annotationType) {
        Advisor advisor = invocation.getAdvisor();
        Annotation annotation = (Annotation)annotationType.cast(advisor.resolveAnnotation(method, annotationType));
        if (annotation == null) {
            annotation = (Annotation)annotationType.cast(advisor.resolveAnnotation(annotationType));
        }
        return (A)annotation;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Method method = ((MethodInvocation)invocation).getMethod();
        TransactionRetry txRetry = this.getAnnotation(invocation, method, TransactionRetry.class);
        int numRetries = txRetry.numRetries();
        long waitTime = TimeUnit.MILLISECONDS.convert(txRetry.waitTime(), txRetry.waitTimeUnit());
        while (true) {
            try {
                return invocation.invokeNext();
            }
            catch (EJBTransactionRolledbackException e) {
                Thread.sleep(waitTime);
                if (--numRetries > 0) continue;
                throw e;
            }
            break;
        }
    }
}

