/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.inject.naming;

import java.util.List;
import javax.naming.Context;
import org.jboss.injection.inject.Injector;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchBoardOperator {
    private static final Logger log = Logger.getLogger(SwitchBoardOperator.class);
    private final Context context;
    private final List<Injector<Context>> injectors;

    public SwitchBoardOperator(Context context, List<Injector<Context>> injectors) {
        if (context == null) {
            throw new IllegalArgumentException("Context can not be null");
        }
        if (injectors == null) {
            throw new IllegalArgumentException("Injectors must not be null");
        }
        this.context = context;
        this.injectors = injectors;
    }

    public void start() {
        log.debugf("Executing %s", new Object[]{this});
        for (Injector<Context> injection : this.injectors) {
            injection.inject(this.context);
        }
    }

    public String toString() {
        return "SwitchBoardOperator{context=" + this.context + ", injectors=" + this.injectors + '}';
    }
}

