/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.net.URL;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractSimpleVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarLibExcludeDeployer
extends AbstractSimpleVFSRealDeployer<JBossAppMetaData> {
    public EarLibExcludeDeployer() {
        super(JBossAppMetaData.class);
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.setOutputs(new String[]{ResourceFilter.class.getName() + ".recurse"});
        this.setTopLevelOnly(true);
    }

    public void deploy(VFSDeploymentUnit unit, JBossAppMetaData jBossAppMetaData) throws DeploymentException {
        try {
            VirtualFile lib;
            VirtualFile root = unit.getRoot();
            String libDir = jBossAppMetaData.getLibraryDirectory();
            if (libDir == null || libDir.length() == 0) {
                libDir = "lib";
            }
            if ((lib = root.getChild(libDir)) != null) {
                UrlExcludeResourceFilter recurseFilter = new UrlExcludeResourceFilter(lib.toURL());
                unit.addAttachment(ResourceFilter.class.getName() + ".recurse", (Object)recurseFilter, ResourceFilter.class);
                this.log.debug((Object)("Excluding ear's lib directory: " + lib));
            }
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Cannot exclude ear's lib.", (Throwable)e);
        }
    }

    private class UrlExcludeResourceFilter
    implements ResourceFilter {
        private URL url;

        private UrlExcludeResourceFilter(URL url) {
            if (url == null) {
                throw new IllegalArgumentException("Null url");
            }
            this.url = url;
        }

        public boolean accepts(ResourceContext rc) {
            try {
                for (VirtualFile file = VFS.getChild((URL)rc.getUrl()); file != null; file = file.getParent()) {
                    if (!this.url.equals(file.toURL())) continue;
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

