/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.local.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jboss.system.server.profileservice.repository.clustered.local.file.AbstractLocalContentChangeAction;
import org.jboss.system.server.profileservice.repository.clustered.local.file.FileBasedSynchronizationActionContext;
import org.jboss.system.server.profileservice.repository.clustered.local.file.FileUtil;
import org.jboss.system.server.profileservice.repository.clustered.sync.AbstractSynchronizationAction;
import org.jboss.system.server.profileservice.repository.clustered.sync.ByteChunk;
import org.jboss.system.server.profileservice.repository.clustered.sync.ContentModification;

public abstract class AbstractFileWriteAction
extends AbstractLocalContentChangeAction {
    private File tempFile;
    private OutputStream stream;

    public AbstractFileWriteAction(File targetFile, FileBasedSynchronizationActionContext context, ContentModification modification) {
        super(targetFile, context, modification);
    }

    protected void writeBytes(ByteChunk bytes) throws IOException {
        try {
            if (bytes == null) {
                throw new IllegalArgumentException("Null bytes");
            }
            if (bytes.getByteCount() < 0) {
                throw new IllegalArgumentException("Illegal byte count " + bytes.getByteCount());
            }
            OutputStream os = this.getOutputStream();
            os.write(bytes.getBytes(), 0, bytes.getByteCount());
        }
        catch (IOException e) {
            this.setRollbackOnly();
            throw e;
        }
        catch (RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    protected void doComplete() throws Exception {
        this.safeCloseStream();
        super.doComplete();
    }

    protected boolean modifyTarget() throws IOException {
        FileUtil.localMove(this.tempFile, this.getTargetFile(), this.getRepositoryContentModification().getItem().getTimestamp());
        return true;
    }

    protected synchronized void safeCleanup(boolean cleanRollback) {
        super.safeCleanup(cleanRollback);
        this.safeCloseStream();
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    private synchronized OutputStream getOutputStream() throws IOException {
        AbstractSynchronizationAction.State s = this.getState();
        if (s != AbstractSynchronizationAction.State.OPEN && s != AbstractSynchronizationAction.State.CANCELLED) {
            throw new IllegalStateException("Cannot write when state is " + (Object)((Object)s));
        }
        if (this.stream == null) {
            FileOutputStream fos = new FileOutputStream(this.getTempFile());
            this.stream = new BufferedOutputStream(fos);
        }
        return this.stream;
    }

    private File getTempFile() throws IOException {
        if (this.tempFile == null) {
            this.tempFile = this.createTempFile();
        }
        return this.tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void safeCloseStream() {
        if (this.stream != null) {
            OutputStream outputStream = this.stream;
            synchronized (outputStream) {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    ContentModification mod = this.getRepositoryContentModification();
                    this.getLogger().debug((Object)("Caught exception closing stream for " + mod.getRootName() + " " + mod.getItem().getRelativePath()), (Throwable)e);
                }
                finally {
                    this.stream = null;
                }
            }
        }
    }
}

