/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.deployers;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.deployers.client.plugins.deployment.AbstractDeployment;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.profileservice.deployment.DeploymentBuilder;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profileservice.deployers.StructureMetaDataBuilder;
import org.jboss.system.server.profileservice.repository.LegacyProfileDeploymentFactory;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VDFDeploymentBuilder
implements DeploymentBuilder<Deployment> {
    private static final VDFDeploymentBuilder instance = new VDFDeploymentBuilder();
    private static final VFSDeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();
    private final StructureMetaDataBuilder deploymentProcessor = new StructureMetaDataBuilder();

    public static VDFDeploymentBuilder getInstance() {
        return instance;
    }

    private VDFDeploymentBuilder() {
    }

    public Deployment createDeployment(ProfileKey key, ProfileDeployment profileDeployment) throws Exception {
        AbstractDeployment d = null;
        if (profileDeployment.getRoot() == null) {
            d = new AbstractDeployment(profileDeployment.getName());
        } else {
            VirtualFile vf = profileDeployment.getRoot();
            if (profileDeployment instanceof LegacyProfileDeploymentFactory.WorkaroundProfileDeployment) {
                try {
                    vf = VFS.getChild((URI)new URI(profileDeployment.getName()));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            d = deploymentFactory.createVFSDeployment(profileDeployment.getName(), vf);
        }
        this.deploymentProcessor.processDeployment(profileDeployment, (Deployment)d);
        return d;
    }
}

