/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.ArrayList;
import java.util.List;
import org.jacorb.orb.ORB;
import org.jacorb.poa.POA;
import org.jacorb.poa.POAManagerMonitor;
import org.jacorb.poa.POAManagerMonitorLightImpl;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.INTERNAL;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer._POAManagerLocalBase;

public class POAManager
extends _POAManagerLocalBase {
    public State state = State.HOLDING;
    private final ORB orb;
    private final List poas = new ArrayList();
    private POAManagerMonitor monitor;
    protected boolean poaCreationFailed;

    protected POAManager(ORB oRB) {
        this.orb = oRB;
        this.monitor = new POAManagerMonitorLightImpl();
        this.monitor.configure(this.orb.getConfiguration());
        this.monitor.init(this);
        this.monitor.openMonitor();
        this.monitor.printMessage("ready");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() throws AdapterInactive {
        this.checkCreation();
        switch (this.state.value()) {
            case 3: {
                throw new AdapterInactive();
            }
            case 1: {
                break;
            }
            default: {
                POA[] pOAArray;
                this.state = State.ACTIVE;
                this.monitor.setToActive();
                Object object = this;
                synchronized (object) {
                    pOAArray = this.poas.toArray(new POA[this.poas.size()]);
                }
                object = new Thread(){

                    public void run() {
                        for (int i = 0; i < pOAArray.length; ++i) {
                            try {
                                pOAArray[i].changeToActive();
                                continue;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                };
                ((Thread)object).setName("POAChangeToActive");
                ((Thread)object).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(boolean bl, boolean bl2) throws AdapterInactive {
        POA[] pOAArray;
        this.checkCreation();
        if (bl2 && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER();
        }
        switch (this.state.value()) {
            case 3: {
                throw new AdapterInactive();
            }
        }
        this.state = State.INACTIVE;
        this.monitor.setToInactive(bl2, bl);
        final boolean bl3 = bl;
        Object object = this;
        synchronized (object) {
            pOAArray = this.poas.toArray(new POA[this.poas.size()]);
        }
        object = new Thread(){

            public void run() {
                for (int i = pOAArray.length - 1; i >= 0; --i) {
                    try {
                        pOAArray[i].changeToInactive(bl3);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        };
        ((Thread)object).setName("POAChangeToInactive");
        ((Thread)object).start();
        if (bl2) {
            try {
                ((Thread)object).join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard_requests(boolean bl) throws AdapterInactive {
        this.checkCreation();
        if (bl && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER();
        }
        switch (this.state.value()) {
            case 3: {
                throw new AdapterInactive();
            }
            case 2: {
                break;
            }
            default: {
                POA[] pOAArray;
                this.state = State.DISCARDING;
                this.monitor.setToDiscarding(bl);
                Object object = this;
                synchronized (object) {
                    pOAArray = this.poas.toArray(new POA[this.poas.size()]);
                }
                object = new Thread(){

                    public void run() {
                        for (int i = pOAArray.length - 1; i >= 0; --i) {
                            try {
                                pOAArray[i].changeToDiscarding();
                                continue;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                };
                ((Thread)object).setName("POAChangeToDiscarding");
                ((Thread)object).start();
                if (!bl) break;
                try {
                    ((Thread)object).join();
                    break;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public State get_state() {
        return this.state;
    }

    protected synchronized POA getRegisteredPOA(String string) {
        for (POA pOA : this.poas) {
            if (!string.equals(pOA._getQualifiedName())) continue;
            return pOA;
        }
        throw new INTERNAL("POA not registered: RootPOA/" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hold_requests(boolean bl) throws AdapterInactive {
        this.checkCreation();
        if (bl && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER();
        }
        switch (this.state.value()) {
            case 3: {
                throw new AdapterInactive();
            }
            case 0: {
                break;
            }
            default: {
                POA[] pOAArray;
                this.state = State.HOLDING;
                this.monitor.setToHolding(bl);
                Object object = this;
                synchronized (object) {
                    pOAArray = this.poas.toArray(new POA[this.poas.size()]);
                }
                object = new Thread(){

                    public void run() {
                        for (int i = pOAArray.length - 1; i >= 0; --i) {
                            try {
                                pOAArray[i].changeToHolding();
                                continue;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                };
                ((Thread)object).setName("POAChangeToHolding");
                ((Thread)object).start();
                if (!bl) break;
                try {
                    ((Thread)object).join();
                    break;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isInInvocationContext() {
        try {
            if (this.orb.getPOACurrent().getORB() == this.orb) {
                return true;
            }
        }
        catch (NoContext noContext) {
            // empty catch block
        }
        return false;
    }

    protected synchronized void registerPOA(POA pOA) {
        if (!this.poas.contains(pOA)) {
            this.poas.add(pOA);
            this.monitor.addPOA(pOA._getQualifiedName());
        }
    }

    protected void setMonitor(POAManagerMonitor pOAManagerMonitor) {
        this.monitor = pOAManagerMonitor;
    }

    protected synchronized void unregisterPOA(POA pOA) {
        this.poas.remove(pOA);
        this.monitor.removePOA(pOA._getQualifiedName());
    }

    private void checkCreation() {
        if (this.poaCreationFailed) {
            throw new INTERNAL("POA Creation failed; unable to deactive");
        }
    }
}

