/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.factories;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static Class<?> loadClass(final ClassLoader cl, final String name) throws PrivilegedActionException, ClassNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return cl.loadClass(name);
        }
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws PrivilegedActionException {
                try {
                    return cl.loadClass(name);
                }
                catch (Exception e) {
                    throw new PrivilegedActionException(e);
                }
            }
        });
    }
}

