/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.transport.backchannel;

import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.ws.core.server.netty.AbstractNettyRequestHandler;
import org.jboss.ws.extensions.wsrm.transport.RMMessage;
import org.jboss.ws.extensions.wsrm.transport.RMUnMarshaller;
import org.jboss.ws.extensions.wsrm.transport.backchannel.RMCallbackHandler;

public final class RMRequestHandlerImpl
extends AbstractNettyRequestHandler {
    private static final Logger LOG = Logger.getLogger(RMRequestHandlerImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        HttpRequest request = (HttpRequest)e.getMessage();
        ChannelBuffer content = request.getContent();
        HashMap<String, Object> requestHeaders = new HashMap<String, Object>();
        for (String headerName : request.getHeaderNames()) {
            requestHeaders.put(headerName, request.getHeaders(headerName));
        }
        boolean error = false;
        try {
            URI requestURI = URI.create(request.getUri());
            String requestPath = requestURI.getRawPath();
            RMMessage message = (RMMessage)RMUnMarshaller.getInstance().read((InputStream)(content.readable() ? new ChannelBufferInputStream(content) : null), null, requestHeaders);
            this.handle(requestPath, message);
        }
        catch (Throwable t) {
            error = true;
            LOG.error((Object)"Error decoding request to the backport", t);
        }
        finally {
            this.writeResponse(e, request, error);
        }
    }

    private void handle(String requestPath, RMMessage message) {
        RMCallbackHandler handler = (RMCallbackHandler)this.getCallback(requestPath);
        if (handler != null) {
            handler.handle(message);
        } else {
            LOG.warn((Object)("No callback handler registered for path: " + requestPath));
        }
    }

    private void writeResponse(MessageEvent e, HttpRequest request, boolean error) {
        CookieDecoder cookieDecoder;
        Set cookies;
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, error ? HttpResponseStatus.INTERNAL_SERVER_ERROR : HttpResponseStatus.NO_CONTENT);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        String cookieString = request.getHeader("Cookie");
        if (cookieString != null && !(cookies = (cookieDecoder = new CookieDecoder()).decode(cookieString)).isEmpty()) {
            CookieEncoder cookieEncoder = new CookieEncoder(true);
            for (Cookie cookie : cookies) {
                cookieEncoder.addCookie(cookie);
            }
            response.addHeader("Set-Cookie", (Object)cookieEncoder.encode());
        }
        ChannelFuture cf = e.getChannel().write((Object)response);
        cf.awaitUninterruptibly();
    }
}

