/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.transport.backchannel;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.ws.core.MessageTrace;
import org.jboss.ws.extensions.wsrm.transport.RMMessage;
import org.jboss.ws.extensions.wsrm.transport.RMUnassignedMessageListener;
import org.jboss.ws.extensions.wsrm.transport.backchannel.RMCallbackHandler;

public final class RMCallbackHandlerImpl
implements RMCallbackHandler {
    private static final Logger logger = Logger.getLogger(RMCallbackHandlerImpl.class);
    private final String handledPath;
    private final Object instanceLock = new Object();
    private Map<String, RMMessage> arrivedMessages = new HashMap<String, RMMessage>();
    private List<RMMessage> arrivedUnassignedMessages = new LinkedList<RMMessage>();
    private RMUnassignedMessageListener listener;

    public RMCallbackHandlerImpl(String handledPath) {
        this.handledPath = handledPath;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered callback handler listening on '" + handledPath + "' request path"));
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public Throwable getFault(String messageId) {
        return null;
    }

    @Override
    public final String getPath() {
        return this.handledPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handle(RMMessage message) {
        Object object = this.instanceLock;
        synchronized (object) {
            String requestMessage = new String(message.getPayload());
            MessageTrace.traceMessage("Incoming RM Response Message (callback)", requestMessage);
            String startPattern = "<wsa:RelatesTo>";
            String endPattern = "</wsa:RelatesTo>";
            int begin = requestMessage.indexOf(startPattern) + startPattern.length();
            int end = requestMessage.indexOf(endPattern);
            if (begin != -1) {
                String messageId = requestMessage.substring(begin, end);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Arrived message id: " + messageId));
                }
                this.arrivedMessages.put(messageId, message);
            } else {
                logger.debug((Object)"Arrived message has no id");
                this.arrivedUnassignedMessages.add(message);
                if (this.listener != null) {
                    this.listener.unassignedMessageReceived();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUnassignedMessageListener(RMUnassignedMessageListener listener) {
        Object object = this.instanceLock;
        synchronized (object) {
            if (this.listener == null) {
                this.listener = listener;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMMessage getMessage(String messageId) {
        Object object = this.instanceLock;
        synchronized (object) {
            while (this.arrivedMessages.get(messageId) == null) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("waiting for response with message id: " + messageId));
                    }
                    this.instanceLock.wait(100L);
                }
                catch (InterruptedException ie) {
                    logger.warn((Object)ie.getMessage(), (Throwable)ie);
                }
            }
            return this.arrivedMessages.get(messageId);
        }
    }
}

