/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.jaxws;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.extensions.wsrm.RMSequence;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.jaxws.RMHandlerAbstractBase;
import org.jboss.ws.extensions.wsrm.protocol.RMConstants;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSerializable;

public final class RMClientHandler
extends RMHandlerAbstractBase {
    private static final RMConstants rmConstants = RMProvider.get().getConstants();

    protected boolean handleOutbound(MessageContext msgContext) {
        this.log.debug((Object)"handling outbound message");
        CommonMessageContext commonMsgContext = (CommonMessageContext)msgContext;
        SOAPAddressingProperties addrProps = (SOAPAddressingProperties)commonMsgContext.get("javax.xml.ws.addressing.context.outbound");
        Map rmOutboundContext = (Map)commonMsgContext.get("wsrm.requestContext");
        List outMsgs = (List)rmOutboundContext.get("wsrm.protocolMessages");
        HashMap<QName, RMSerializable> data = new HashMap<QName, RMSerializable>();
        String optionalMessageId = addrProps.getMessageID() != null ? addrProps.getMessageID().getURI().toString() : null;
        rmOutboundContext.put("wsrm.wsaMessageId", optionalMessageId);
        rmOutboundContext.put("wsrm.protocolMessagesMapping", data);
        SOAPMessage soapMessage = ((SOAPMessageContext)commonMsgContext).getMessage();
        RMSequence sequenceImpl = (RMSequence)rmOutboundContext.get("wsrm.sequenceReference");
        this.serialize(rmConstants.getCreateSequenceQName(), (List<QName>)outMsgs, data, soapMessage, sequenceImpl);
        this.serialize(rmConstants.getSequenceQName(), (List<QName>)outMsgs, data, soapMessage, sequenceImpl);
        this.serialize(rmConstants.getAckRequestedQName(), (List<QName>)outMsgs, data, soapMessage, sequenceImpl);
        this.serialize(rmConstants.getCloseSequenceQName(), (List<QName>)outMsgs, data, soapMessage, sequenceImpl);
        this.serialize(rmConstants.getTerminateSequenceQName(), (List<QName>)outMsgs, data, soapMessage, sequenceImpl);
        this.serialize(rmConstants.getSequenceAcknowledgementQName(), (List<QName>)outMsgs, data, soapMessage, sequenceImpl);
        if (outMsgs.size() != 0 && data.size() == 0) {
            throw new RMException("RM handler did not serialize WS-RM message to the payload");
        }
        return true;
    }

    protected boolean handleInbound(MessageContext msgContext) {
        this.log.debug((Object)"handling inbound message");
        SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
        HashMap<String, Cloneable> rmResponseContext = new HashMap<String, Cloneable>();
        LinkedList<QName> messages = new LinkedList<QName>();
        rmResponseContext.put("wsrm.protocolMessages", messages);
        HashMap<QName, RMSerializable> data = new HashMap<QName, RMSerializable>();
        rmResponseContext.put("wsrm.protocolMessagesMapping", data);
        this.deserialize(rmConstants.getCreateSequenceResponseQName(), soapMessage, messages, data);
        this.deserialize(rmConstants.getAckRequestedQName(), soapMessage, messages, data);
        this.deserialize(rmConstants.getSequenceQName(), soapMessage, messages, data);
        this.deserialize(rmConstants.getSequenceAcknowledgementQName(), soapMessage, messages, data);
        this.deserialize(rmConstants.getCloseSequenceResponseQName(), soapMessage, messages, data);
        this.deserialize(rmConstants.getTerminateSequenceResponseQName(), soapMessage, messages, data);
        if (data.size() == 0) {
            throw new RMException("RM handler was not able to find WS-RM message in the payload");
        }
        msgContext.put((Object)"wsrm.responseContext", rmResponseContext);
        msgContext.setScope("wsrm.responseContext", MessageContext.Scope.APPLICATION);
        return true;
    }
}

