/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.element;

import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.element.Token;
import org.jboss.ws.extensions.security.element.X509Token;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BinarySecurityToken
implements Token {
    private Document doc;
    private String id;
    private Element cachedElement;

    public static BinarySecurityToken createBinarySecurityToken(Element element) throws WSSecurityException {
        String valueType = element.getAttribute("ValueType");
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(valueType)) {
            return new X509Token(element);
        }
        throw new WSSecurityException("Unkown Binary Security Token!!!");
    }

    public BinarySecurityToken(Document doc) {
        this.doc = doc;
    }

    public abstract String getValueType();

    public abstract String getEncodingType();

    public abstract String getEncodedValue(boolean var1);

    public String getId() {
        if (this.id == null) {
            this.id = Util.generateId("token");
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Element getElement() {
        if (this.cachedElement != null) {
            return this.cachedElement;
        }
        Element element = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:BinarySecurityToken");
        element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", this.getId());
        element.setAttribute("ValueType", this.getValueType());
        element.setAttribute("EncodingType", this.getEncodingType());
        element.appendChild(this.doc.createTextNode(this.getEncodedValue(false)));
        this.cachedElement = element;
        return this.cachedElement;
    }

    public Element getSTRTransformElement() {
        Element element = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:BinarySecurityToken");
        Util.addNamespace(element, "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        element.setAttribute("ValueType", this.getValueType());
        element.appendChild(this.doc.createTextNode(this.getEncodedValue(true)));
        return element;
    }
}

