/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.util.List;
import org.apache.xml.security.Init;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.extensions.security.operation.EncodingOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SecurityEncoder {
    private List<EncodingOperation> operations;
    private SecurityStore store;

    public SecurityEncoder(List<EncodingOperation> operations, SecurityStore store) {
        Init.init();
        this.operations = operations;
        this.store = store;
    }

    private void attachHeader(SecurityHeader header, Document message) {
        Element soapHeader = Util.findOrCreateSoapHeader(message.getDocumentElement());
        try {
            Element wsse = header.getElement();
            wsse.setAttributeNS(soapHeader.getNamespaceURI(), soapHeader.getPrefix() + ":mustUnderstand", "1");
            soapHeader.insertBefore(wsse, soapHeader.getFirstChild());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void encode(Document message) throws WSSecurityException {
        SecurityHeader header = new SecurityHeader(message);
        for (EncodingOperation operation : this.operations) {
            operation.process(message, header, this.store);
        }
        this.attachHeader(header, message);
    }
}

