/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.jboss.logging.Logger;
import org.jboss.ws.core.soap.SOAPContent;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.XMLContent;
import org.jboss.ws.core.soap.XMLFragment;
import org.w3c.dom.Node;

public class DOMContent
extends SOAPContent {
    private static Logger log = Logger.getLogger(DOMContent.class);
    private Source payload;

    protected DOMContent(SOAPContentElement container) {
        super(container);
    }

    @Override
    SOAPContent.State getState() {
        return SOAPContent.State.DOM_VALID;
    }

    @Override
    SOAPContent transitionTo(SOAPContent.State nextState) {
        SOAPContent next = null;
        if (SOAPContent.State.XML_VALID == nextState) {
            log.debug((Object)"getXMLFragment from DOM");
            DOMSource domSource = new DOMSource((Node)((Object)this.container));
            XMLFragment fragment = new XMLFragment(domSource);
            if (log.isDebugEnabled()) {
                log.debug((Object)("xmlFragment: " + fragment));
            }
            XMLContent xmlValid = new XMLContent(this.container);
            xmlValid.setXMLFragment(fragment);
            next = xmlValid;
        } else if (SOAPContent.State.OBJECT_VALID == nextState) {
            XMLFragment fragment = new XMLFragment(new DOMSource((Node)((Object)this.container)));
            XMLContent tmpState = new XMLContent(this.container);
            tmpState.setXMLFragment(fragment);
            next = tmpState.transitionTo(SOAPContent.State.OBJECT_VALID);
        } else if (SOAPContent.State.DOM_VALID == nextState) {
            next = this;
        } else {
            throw new IllegalArgumentException("Illegal state requested: " + (Object)((Object)nextState));
        }
        return next;
    }

    @Override
    public Source getPayload() {
        return new DOMSource((Node)((Object)this.container));
    }

    public void setPayload(Source source) {
        if (!(source instanceof DOMSource)) {
            throw new IllegalArgumentException("DOMSource expected, but got: " + source);
        }
        this.payload = source;
    }

    @Override
    public XMLFragment getXMLFragment() {
        throw new IllegalStateException("XMLFragment not available");
    }

    @Override
    public void setXMLFragment(XMLFragment xmlFragment) {
        throw new IllegalStateException("XMLFragment not available");
    }

    @Override
    public Object getObjectValue() {
        throw new IllegalStateException("Object value not available");
    }

    @Override
    public void setObjectValue(Object objValue) {
        throw new IllegalStateException("Object value not available");
    }
}

