/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.spi.http;

import java.util.LinkedList;
import java.util.List;
import org.jboss.ws.core.jaxws.spi.EndpointImpl;
import org.jboss.ws.core.jaxws.spi.http.HttpContext;
import org.jboss.ws.core.jaxws.spi.http.HttpServer;
import org.jboss.ws.core.jaxws.spi.http.NettyCallbackHandlerImpl;
import org.jboss.ws.core.jaxws.spi.http.NettyHandlerDeploymentAspect;
import org.jboss.ws.core.jaxws.spi.http.NettyHttpContext;
import org.jboss.ws.core.jaxws.spi.http.NettyRequestHandlerFactoryImpl;
import org.jboss.ws.core.jaxws.spi.http.NettyRequestHandlerImpl;
import org.jboss.ws.core.server.netty.NettyCallbackHandler;
import org.jboss.ws.core.server.netty.NettyHttpServer;
import org.jboss.ws.core.server.netty.NettyHttpServerFactory;
import org.jboss.ws.core.server.netty.NettyRequestHandlerFactory;
import org.jboss.wsf.common.ResourceLoaderAdapter;
import org.jboss.wsf.framework.deployment.BackwardCompatibleContextRootDeploymentAspect;
import org.jboss.wsf.framework.deployment.DeploymentAspectManagerImpl;
import org.jboss.wsf.framework.deployment.EndpointAddressDeploymentAspect;
import org.jboss.wsf.framework.deployment.EndpointLifecycleDeploymentAspect;
import org.jboss.wsf.framework.deployment.EndpointNameDeploymentAspect;
import org.jboss.wsf.framework.deployment.EndpointRegistryDeploymentAspect;
import org.jboss.wsf.framework.deployment.URLPatternDeploymentAspect;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.DeploymentModelFactory;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.stack.jbws.EagerInitializeDeploymentAspect;
import org.jboss.wsf.stack.jbws.PublishContractDeploymentAspect;
import org.jboss.wsf.stack.jbws.ServiceEndpointInvokerDeploymentAspect;
import org.jboss.wsf.stack.jbws.UnifiedMetaDataDeploymentAspect;

final class NettyHttpServerAdapter
implements HttpServer {
    private static final SPIProvider SPI_PROVIDER = SPIProviderResolver.getInstance().getProvider();
    private static final DeploymentModelFactory DEPLOYMENT_FACTORY = (DeploymentModelFactory)SPI_PROVIDER.getSPI(DeploymentModelFactory.class);
    private static final NettyRequestHandlerFactory<NettyRequestHandlerImpl> REQUEST_HANDLER_FACTORY = NettyRequestHandlerFactoryImpl.getInstance();

    @Override
    public HttpContext createContext(String ctx) {
        return new NettyHttpContext(this, ctx);
    }

    @Override
    public void publish(HttpContext ctx, javax.xml.ws.Endpoint endpoint) {
        EndpointImpl epImpl = (EndpointImpl)endpoint;
        String contextRoot = ctx.getContextRoot();
        Deployment dep = this.newDeployment(epImpl, contextRoot);
        DeploymentAspectManagerImpl daManager = new DeploymentAspectManagerImpl();
        daManager.setDeploymentAspects(this.getDeploymentAspects());
        daManager.deploy(dep);
        epImpl.setDeployment(dep);
        NettyHttpServer server = NettyHttpServerFactory.getNettyHttpServer(epImpl.getPort(), REQUEST_HANDLER_FACTORY);
        NettyCallbackHandlerImpl callback = new NettyCallbackHandlerImpl(epImpl.getPath(), contextRoot, this.getEndpointRegistryPath(epImpl));
        server.registerCallback(callback);
    }

    @Override
    public void destroy(HttpContext ctx, javax.xml.ws.Endpoint endpoint) {
        EndpointImpl epImpl = (EndpointImpl)endpoint;
        NettyHttpServer server = NettyHttpServerFactory.getNettyHttpServer(epImpl.getPort(), REQUEST_HANDLER_FACTORY);
        NettyCallbackHandler callback = server.getCallback(epImpl.getPath());
        server.unregisterCallback(callback);
        DeploymentAspectManagerImpl daManager = new DeploymentAspectManagerImpl();
        daManager.setDeploymentAspects(this.getDeploymentAspects());
        daManager.undeploy(epImpl.getDeployment());
    }

    private String getEndpointRegistryPath(EndpointImpl endpoint) {
        return endpoint.getPath() + "-port-" + endpoint.getPort();
    }

    private Deployment newDeployment(EndpointImpl epImpl, String contextRoot) {
        Class<?> endpointClass = this.getEndpointClass(epImpl);
        ClassLoader loader = endpointClass.getClassLoader();
        ArchiveDeployment dep = (ArchiveDeployment)DEPLOYMENT_FACTORY.newDeployment(contextRoot, loader);
        Endpoint endpoint = DEPLOYMENT_FACTORY.newEndpoint(endpointClass.getName());
        endpoint.setShortName(this.getEndpointRegistryPath(epImpl));
        endpoint.setURLPattern(epImpl.getPathWithoutContext());
        dep.getService().addEndpoint(endpoint);
        dep.setRootFile((UnifiedVirtualFile)new ResourceLoaderAdapter(loader));
        dep.setRuntimeClassLoader(loader);
        dep.setType(Deployment.DeploymentType.JAXWS_JSE);
        dep.getService().setContextRoot(contextRoot);
        dep.getService().setProperty("protocol", (Object)"http");
        dep.getService().setProperty("host", (Object)"127.0.0.1");
        dep.getService().setProperty("port", (Object)epImpl.getPort());
        return dep;
    }

    private List<DeploymentAspect> getDeploymentAspects() {
        LinkedList<DeploymentAspect> retVal = new LinkedList<DeploymentAspect>();
        retVal.add((DeploymentAspect)new NettyHandlerDeploymentAspect());
        retVal.add((DeploymentAspect)new BackwardCompatibleContextRootDeploymentAspect());
        retVal.add((DeploymentAspect)new URLPatternDeploymentAspect());
        retVal.add((DeploymentAspect)new EndpointAddressDeploymentAspect());
        retVal.add((DeploymentAspect)new EndpointNameDeploymentAspect());
        retVal.add((DeploymentAspect)new UnifiedMetaDataDeploymentAspect());
        retVal.add((DeploymentAspect)new ServiceEndpointInvokerDeploymentAspect());
        retVal.add((DeploymentAspect)new PublishContractDeploymentAspect());
        retVal.add((DeploymentAspect)new EagerInitializeDeploymentAspect());
        retVal.add((DeploymentAspect)new EndpointRegistryDeploymentAspect());
        retVal.add((DeploymentAspect)new EndpointLifecycleDeploymentAspect());
        return retVal;
    }

    private Class<?> getEndpointClass(javax.xml.ws.Endpoint endpoint) {
        Object implementor = endpoint.getImplementor();
        return implementor instanceof Class ? (Class<?>)implementor : implementor.getClass();
    }
}

