/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.AbstractSocketFactory;
import org.jacorb.orb.listener.SSLHandshakeListener;
import org.jacorb.orb.listener.SSLSessionListener;
import org.jacorb.security.ssl.sun_jsse.JSSEUtil;
import org.jacorb.security.ssl.sun_jsse.KeyStoreUtil;
import org.jacorb.security.ssl.sun_jsse.SSLRandom;

public class SSLSocketFactory
extends AbstractSocketFactory {
    private SocketFactory factory = null;
    private String[] cipher_suites = null;
    private String[] enabledProtocols = null;
    private TrustManager trustManager = null;
    private boolean trusteesFromKS = false;
    private short clientSupportedOptions = 0;
    private String keystore_location = null;
    private String keystore_passphrase = null;
    private final SSLSessionListener sslListener;
    private SSLRandom sslRandom;

    public SSLSocketFactory(ORB oRB) {
        this.sslListener = oRB.getTransportManager().getSocketFactoryManager().getSSLListener();
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration configuration2;
        block6: {
            super.configure(configuration);
            configuration2 = configuration;
            this.sslRandom = new SSLRandom();
            this.sslRandom.configure(configuration);
            this.trusteesFromKS = configuration.getAttributeAsBoolean("jacorb.security.jsse.trustees_from_ks", false);
            this.keystore_location = configuration.getAttribute("jacorb.security.keystore", "UNSET");
            this.keystore_passphrase = configuration.getAttribute("jacorb.security.keystore_password", "UNSET");
            this.clientSupportedOptions = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.client.supported_options", "0"), 16);
            try {
                this.trustManager = (TrustManager)configuration.getAttributeAsObject("jacorb.security.ssl.client.trust_manager");
            }
            catch (ConfigurationException configurationException) {
                if (!this.logger.isErrorEnabled()) break block6;
                this.logger.error("TrustManager object creation failed. Please check value of property 'jacorb.security.ssl.client.trust_manager'. Current value: " + configuration.getAttribute("jacorb.security.ssl.client.trust_manager", ""), (Throwable)configurationException);
            }
        }
        if (JSSEUtil.isJDK14() && configuration.getAttribute("jacorb.security.ssl.client.protocols", null) != null) {
            this.enabledProtocols = (String[])configuration.getAttributeList("jacorb.security.ssl.client.protocols").toArray();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting user specified client enabled protocols : " + configuration.getAttribute("jacorb.security.ssl.client.protocols", ""));
            }
        }
        try {
            this.factory = this.createSocketFactory();
        }
        catch (Exception exception) {
            this.logger.error("Unable to create SSLSocketFactory!", (Throwable)exception);
            throw new ConfigurationException("Unable to create SSLSocketFactory!", exception);
        }
        List list = configuration2.getAttributeList("jacorb.security.ssl.client.cipher_suites");
        this.cipher_suites = list.toArray(new String[list.size()]);
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        SSLSocket sSLSocket = (SSLSocket)this.factory.createSocket(string, n);
        this.initSSLSocket(sSLSocket);
        return sSLSocket;
    }

    protected Socket doCreateSocket(String string, int n, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)this.factory.createSocket();
        sSLSocket.connect(new InetSocketAddress(string, n), n2);
        this.initSSLSocket(sSLSocket);
        return sSLSocket;
    }

    private void initSSLSocket(SSLSocket sSLSocket) {
        if (this.cipher_suites.length > 0) {
            sSLSocket.setEnabledCipherSuites(this.cipher_suites);
        }
        if (this.enabledProtocols != null) {
            JSSEUtil.setEnabledProtocols(sSLSocket, this.enabledProtocols);
        }
        sSLSocket.addHandshakeCompletedListener(new SSLHandshakeListener(this.logger, this.sslListener));
    }

    public boolean isSSL(Socket socket) {
        return socket instanceof SSLSocket;
    }

    private SocketFactory createSocketFactory() throws IOException, GeneralSecurityException {
        TrustManager[] trustManagerArray;
        JSSEUtil.registerSecurityProvider();
        KeyManagerFactory keyManagerFactory = null;
        KeyStore keyStore = null;
        if (this.trusteesFromKS || (this.clientSupportedOptions & 0x40) != 0) {
            keyStore = KeyStoreUtil.getKeyStore(this.keystore_location, this.keystore_passphrase.toCharArray());
            if ((this.clientSupportedOptions & 0x40) != 0) {
                keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                keyManagerFactory.init(keyStore, this.keystore_passphrase.toCharArray());
            }
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        if (keyStore != null && this.trusteesFromKS) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Loading certs from keystore " + keyStore.getType());
            }
            trustManagerFactory.init(keyStore);
        } else {
            trustManagerFactory.init((KeyStore)null);
        }
        if (this.trustManager == null) {
            trustManagerArray = trustManagerFactory.getTrustManagers();
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting user specified client TrustManger : " + this.trustManager.getClass().getName());
            }
            trustManagerArray = new TrustManager[]{this.trustManager};
        }
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(keyManagerFactory == null ? null : keyManagerFactory.getKeyManagers(), trustManagerArray, this.sslRandom.getSecureRandom());
        return sSLContext.getSocketFactory();
    }
}

