/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.protobuf;

import com.google.protobuf.CodedInputStream;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class ProtobufVarint32FrameDecoder
extends FrameDecoder {
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        buffer.markReaderIndex();
        byte[] buf = new byte[5];
        for (int i = 0; i < 5 && buffer.readable(); ++i) {
            buf[i] = buffer.readByte();
            if (buf[i] < 0) continue;
            int messageSize = CodedInputStream.newInstance((byte[])buf, (int)0, (int)(i + 1)).readRawVarint32();
            if (buffer.readableBytes() < messageSize) break;
            return buffer.readBytes(messageSize);
        }
        buffer.resetReaderIndex();
        return null;
    }
}

