/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Concept;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.scout.registry.infomodel.ClassificationSchemeImpl;
import org.apache.ws.scout.registry.infomodel.ConceptImpl;
import org.apache.ws.scout.registry.infomodel.InternationalStringImpl;
import org.apache.ws.scout.registry.infomodel.KeyImpl;

public class EnumerationHelper {
    private static Log log = LogFactory.getLog(EnumerationHelper.class);
    private static final String UDDI_ORG_TYPES = "C1ACF26D-9672-4404-9D70-39B756E62AB4";
    private static final String OBJECT_TYPE = "ObjectType";
    private static final String ASSOCIATION_TYPE = "AssociationType";
    private static final String URL_TYPE = "URLType";
    private static final String PHONE_TYPE = "PhoneType";
    private static final String POSTAL_ADDRESS_ATTRIBUTES_STR = "PostalAddressAttributes";
    private static final String[] TYPES = new String[]{"ObjectType", "AssociationType", "URLType", "PhoneType", "PostalAddressAttributes"};
    private static final String[] OBJECT_TYPES = new String[]{"ExternalLink", "Package", "ExternalId", "Association", "Classification", "Concept", "AuditableEvent", "User", "Organization", "CPA", "CPP", "Service", "ServiceBinding", "Process", "WSDL", "ExtrinsicObj", "Organization", "User"};
    private static final String[] ASSOCIATION_TYPES = new String[]{"RelatedTo", "ExternallyLinks", "Contains", "Extends", "Implements", "InstanceOf", "Supersedes", "Uses", "HasMember", "EquivalentTo", "HasChild", "HasParent", "Replaces", "ResponsibleFor", "SubmitterOf"};
    private static final String[] URL_TYPES = new String[]{"HTTP", "HTTPS", "SMTP", "FAX", "PHONE", "OTHER"};
    private static final String[] PHONE_TYPES = new String[]{"Office", "Home", "Mobile", "Beeper", "FAX"};
    private static final String[] POSTAL_ADDRESS_ATTRIBUTES = new String[]{"StreetNumber", "Street", "City", "State", "PostalCode", "Country"};
    private static final ArrayList<String> TYPES_LIST = new ArrayList<String>(Arrays.asList(TYPES));
    private static final ArrayList<String> OBJECT_TYPES_LIST = new ArrayList<String>(Arrays.asList(OBJECT_TYPES));
    private static final ArrayList<String> ASSOCIATION_TYPES_LIST = new ArrayList<String>(Arrays.asList(ASSOCIATION_TYPES));
    private static final ArrayList<String> URL_TYPES_LIST = new ArrayList<String>(Arrays.asList(URL_TYPES));
    private static final ArrayList<String> PHONE_TYPES_LIST = new ArrayList<String>(Arrays.asList(PHONE_TYPES));
    private static final ArrayList<String> POSTAL_ADDRESS_ATTRIBUTES_LIST = new ArrayList<String>(Arrays.asList(POSTAL_ADDRESS_ATTRIBUTES));
    private static Map<String, ArrayList<String>> typesMap = new HashMap<String, ArrayList<String>>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Concept getConceptByPath(String path) throws IllegalArgumentException, JAXRException {
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        String firstToken = null;
        String secondToken = null;
        if (!tokenizer.hasMoreTokens()) throw new IllegalArgumentException("Expected two token separated with a forward slash (/)");
        firstToken = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens()) throw new IllegalArgumentException("Expected two token separated with a forward slash (/)");
        secondToken = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens()) return EnumerationHelper.createConcept(firstToken, secondToken);
        log.warn((Object)("Looking for 2 tokens. " + tokenizer.nextToken() + " will be ignored"));
        return EnumerationHelper.createConcept(firstToken, secondToken);
    }

    private static Concept createConcept(String firstToken, String secondToken) throws JAXRException, IllegalArgumentException {
        if (!TYPES_LIST.contains(firstToken)) {
            throw new IllegalArgumentException("Expected the path to start with one of " + TYPES);
        }
        ClassificationSchemeImpl cs = new ClassificationSchemeImpl(null);
        cs.setName(new InternationalStringImpl(firstToken));
        cs.setKey(new KeyImpl(firstToken));
        ArrayList<String> conceptStrings = typesMap.get(firstToken);
        if (!conceptStrings.contains(secondToken)) {
            throw new IllegalArgumentException("Expected the path to end with one of " + conceptStrings.toArray());
        }
        ConceptImpl concept = new ConceptImpl(null);
        concept.setName(new InternationalStringImpl(secondToken.toLowerCase()));
        concept.setValue(secondToken);
        concept.setKey(new KeyImpl(UDDI_ORG_TYPES));
        concept.setScheme(cs);
        return concept;
    }

    static {
        typesMap.put(OBJECT_TYPE, OBJECT_TYPES_LIST);
        typesMap.put(ASSOCIATION_TYPE, ASSOCIATION_TYPES_LIST);
        typesMap.put(URL_TYPE, URL_TYPES_LIST);
        typesMap.put(PHONE_TYPE, PHONE_TYPES_LIST);
        typesMap.put(POSTAL_ADDRESS_ATTRIBUTES_STR, POSTAL_ADDRESS_ATTRIBUTES_LIST);
    }
}

