/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Properties;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.FederatedConnection;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnsupportedCapabilityException;
import org.apache.ws.scout.registry.ConnectionImpl;

public class ConnectionFactoryImpl
extends ConnectionFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String QUERYMANAGER_PROPERTY = "javax.xml.registry.queryManagerURL";
    private static final String LIFECYCLEMANAGER_PROPERTY = "javax.xml.registry.lifeCycleManagerURL";
    private static final String SEMANTICEQUIVALENCES_PROPERTY = "javax.xml.registry.semanticEquivalences";
    private static final String POSTALADDRESSSCHEME_PROPERTY = "javax.xml.registry.postalAddressScheme";
    private static final String AUTHENTICATIONMETHOD_PROPERTY = "javax.xml.registry.security.authenticationMethod";
    private static final String MAXROWS_PROPERTY = "javax.xml.registry.uddi.maxRows";
    private String queryManagerURL;
    private String lifeCycleManagerURL;
    private String transportClass;
    private String semanticEquivalences;
    private String authenticationMethod;
    private Integer maxRows;
    private String postalAddressScheme;

    public Connection createConnection() throws JAXRException {
        URI lifeCycleManager;
        URI queryManager;
        if (this.queryManagerURL == null) {
            throw new InvalidRequestException("queryManager is not set");
        }
        try {
            queryManager = new URI(this.queryManagerURL);
        }
        catch (URISyntaxException e) {
            throw new InvalidRequestException("Invalid queryManagerURL: " + this.queryManagerURL, (Throwable)e);
        }
        try {
            lifeCycleManager = this.lifeCycleManagerURL == null ? queryManager : new URI(this.lifeCycleManagerURL);
        }
        catch (URISyntaxException e) {
            throw new InvalidRequestException("Invalid lifeCycleManagerURL: " + this.lifeCycleManagerURL, (Throwable)e);
        }
        return new ConnectionImpl(queryManager, lifeCycleManager, this.transportClass, null, this.maxRows == null ? -1 : this.maxRows);
    }

    public FederatedConnection createFederatedConnection(Collection collection) throws JAXRException {
        throw new UnsupportedCapabilityException("FederatedConnections are not supported in this release");
    }

    public Properties getProperties() {
        Properties props = new Properties();
        if (this.queryManagerURL != null) {
            props.put(QUERYMANAGER_PROPERTY, this.queryManagerURL);
        }
        if (this.lifeCycleManagerURL != null) {
            props.put(LIFECYCLEMANAGER_PROPERTY, this.lifeCycleManagerURL);
        }
        if (this.semanticEquivalences != null) {
            props.put(SEMANTICEQUIVALENCES_PROPERTY, this.semanticEquivalences);
        }
        if (this.postalAddressScheme != null) {
            props.put(POSTALADDRESSSCHEME_PROPERTY, this.postalAddressScheme);
        }
        if (this.authenticationMethod != null) {
            props.put(AUTHENTICATIONMETHOD_PROPERTY, this.authenticationMethod);
        }
        if (this.maxRows != null) {
            props.put(MAXROWS_PROPERTY, this.maxRows.toString());
        }
        return props;
    }

    public void setProperties(Properties properties) {
        this.queryManagerURL = properties.getProperty(QUERYMANAGER_PROPERTY);
        this.lifeCycleManagerURL = properties.getProperty(LIFECYCLEMANAGER_PROPERTY);
        this.transportClass = properties.getProperty("scout.proxy.transportClass");
        this.semanticEquivalences = properties.getProperty(SEMANTICEQUIVALENCES_PROPERTY);
        this.authenticationMethod = properties.getProperty(AUTHENTICATIONMETHOD_PROPERTY);
        this.postalAddressScheme = properties.getProperty(POSTALADDRESSSCHEME_PROPERTY);
        String val = properties.getProperty(MAXROWS_PROPERTY);
        this.maxRows = val == null ? null : Integer.valueOf(val);
    }

    public static ConnectionFactory newInstance() {
        return new ConnectionFactoryImpl();
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public String getLifeCycleManagerURL() {
        return this.lifeCycleManagerURL;
    }

    public void setLifeCycleManagerURL(String lifeCycleManagerURL) {
        this.lifeCycleManagerURL = lifeCycleManagerURL;
    }

    public Integer getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(Integer maxRows) {
        this.maxRows = maxRows;
    }

    public String getPostalAddressScheme() {
        return this.postalAddressScheme;
    }

    public void setPostalAddressScheme(String postalAddressScheme) {
        this.postalAddressScheme = postalAddressScheme;
    }

    public String getQueryManagerURL() {
        return this.queryManagerURL;
    }

    public void setQueryManagerURL(String queryManagerURL) {
        this.queryManagerURL = queryManagerURL;
    }

    public String getSemanticEquivalences() {
        return this.semanticEquivalences;
    }

    public void setSemanticEquivalences(String semanticEquivalences) {
        this.semanticEquivalences = semanticEquivalences;
    }

    public String getTransportClass() {
        return this.transportClass;
    }

    public void setTransportClass(String transportClass) {
        this.transportClass = transportClass;
    }
}

