/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classpool.spi;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javassist.ClassPool;
import javassist.CtClass;
import org.jboss.classpool.helpers.ClassLoaderUtils;
import org.jboss.classpool.scoped.ScopedClassPool;
import org.jboss.classpool.scoped.ScopedClassPoolRepository;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractClassPool
extends ScopedClassPool {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    protected final ConcurrentHashMap<String, String> generatedClasses = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Boolean> localResources = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Boolean> loadedButNotWovenClasses = new ConcurrentHashMap();
    public static final Class<SearchAllRegisteredLoadersSearchStrategy> SEARCH_ALL_STRATEGY = SearchAllRegisteredLoadersSearchStrategy.class;
    public static final Class<SearchLocalLoaderLoaderSearchStrategy> SEARCH_LOCAL_ONLY_STRATEGY = SearchLocalLoaderLoaderSearchStrategy.class;
    private final ClassPoolSearchStrategy searchStrategy;
    private final Map<AbstractClassPool, Boolean> children = new WeakHashMap<AbstractClassPool, Boolean>();

    public AbstractClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository) {
        this(cl, src, repository, false);
    }

    protected AbstractClassPool(ClassPool src, ScopedClassPoolRepository repository) {
        this(null, src, repository, true);
    }

    private AbstractClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, boolean isTemp) {
        this(cl, src, repository, SEARCH_ALL_STRATEGY, isTemp);
    }

    public AbstractClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, Class<? extends ClassPoolSearchStrategy> searchStrategy) {
        this(cl, src, repository, searchStrategy, false);
    }

    public AbstractClassPool(ClassPool src, ScopedClassPoolRepository repository, Class<? extends ClassPoolSearchStrategy> searchStrategy) {
        this(null, src, repository, searchStrategy, true);
    }

    private AbstractClassPool(ClassLoader cl, ClassPool src, ScopedClassPoolRepository repository, Class<? extends ClassPoolSearchStrategy> searchStrategy, boolean isTemp) {
        super(cl, src, repository, isTemp);
        if (searchStrategy == SEARCH_ALL_STRATEGY) {
            this.searchStrategy = new SearchAllRegisteredLoadersSearchStrategy();
        } else if (searchStrategy == SEARCH_LOCAL_ONLY_STRATEGY) {
            this.searchStrategy = new SearchLocalLoaderLoaderSearchStrategy();
        } else {
            try {
                this.searchStrategy = searchStrategy.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error instantiating search strategy class " + searchStrategy, e);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)((Object)((Object)this) + " creating pool for loader " + cl + " searchStrategy:" + this.searchStrategy + " isTemp:" + isTemp));
        }
        this.registerWithParent();
    }

    private void registerWithParent() {
        if (this.parent != null && this.parent instanceof AbstractClassPool) {
            ((AbstractClassPool)this.parent).children.put(this, Boolean.TRUE);
        }
    }

    private void unregisterWithParent() {
        if (this.parent != null && this.parent instanceof AbstractClassPool) {
            ((AbstractClassPool)this.parent).children.remove((Object)this);
        }
    }

    public void registerGeneratedClass(String className) {
        this.generatedClasses.put(className, className);
    }

    public boolean isGeneratedClass(String className) {
        return this.generatedClasses.containsKey(className);
    }

    public void doneGeneratingClass(String className) {
        this.generatedClasses.remove(className);
    }

    public void close() {
        super.close();
        this.unregisterWithParent();
        Iterator<AbstractClassPool> childIterator = this.children.keySet().iterator();
        while (childIterator.hasNext()) {
            AbstractClassPool child = childIterator.next();
            childIterator.remove();
            if (child.getClassLoader() == null) continue;
            child.close();
        }
    }

    public CtClass getCached(String classname) {
        return this.searchStrategy.getCached(classname);
    }

    public void cacheCtClass(String classname, CtClass c, boolean dynamic) {
        boolean trace = this.logger.isTraceEnabled();
        if (trace) {
            this.logger.trace((Object)((Object)((Object)this) + " caching " + classname));
        }
        super.cacheCtClass(classname, c, true);
        if (dynamic) {
            if (trace) {
                this.logger.trace((Object)((Object)((Object)this) + " registering dynamic class " + classname));
            }
            this.doneGeneratingClass(classname);
            String resourcename = this.getResourceName(classname);
            this.localResources.put(resourcename, Boolean.TRUE);
        }
    }

    protected boolean includeInGlobalSearch() {
        return true;
    }

    protected String getResourceName(String classname) {
        return ClassLoaderUtils.getResourceName(classname);
    }

    protected final boolean isLocalResource(String resourceName, boolean trace) {
        String classResourceName = resourceName;
        Boolean isLocal = this.localResources.get(classResourceName);
        if (isLocal != null) {
            if (trace) {
                this.logger.trace((Object)((Object)((Object)this) + " " + resourceName + " is local " + isLocal));
            }
            return isLocal;
        }
        boolean localResource = this.isLocalClassLoaderResource(classResourceName);
        this.localResources.put(classResourceName, localResource ? Boolean.TRUE : Boolean.FALSE);
        if (trace) {
            this.logger.trace((Object)((Object)((Object)this) + " " + resourceName + " is local " + localResource));
        }
        return localResource;
    }

    protected boolean isLocalClassLoaderResource(String classResourceName) {
        return this.getClassLoader().getResource(classResourceName) != null;
    }

    public String toString() {
        ClassLoader cl = null;
        try {
            cl = this.getClassLoader();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return ((Object)((Object)this)).getClass().getName() + "@" + System.identityHashCode((Object)this) + " " + super.toString() + " - dcl:" + cl;
    }

    protected String getClassPoolLogStringForClass(CtClass clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.getClassPool() == null) {
            return null;
        }
        return clazz.getClassPool().toString();
    }

    static {
        ClassPool.doPruning = false;
        ClassPool.releaseUnmodifiedClassFile = false;
    }

    private class SearchLocalLoaderLoaderSearchStrategy
    implements ClassPoolSearchStrategy {
        Logger logger = Logger.getLogger(this.getClass());

        private SearchLocalLoaderLoaderSearchStrategy() {
        }

        public CtClass getCached(String classname) {
            boolean trace = this.logger.isTraceEnabled();
            if (trace) {
                this.logger.trace((Object)(this + " " + (Object)((Object)AbstractClassPool.this) + " searching just this pool for " + classname));
            }
            CtClass clazz = AbstractClassPool.this.getCachedLocally(classname);
            if (trace) {
                this.logger.trace((Object)(this + " " + (Object)((Object)AbstractClassPool.this) + " found " + classname + " in pool" + AbstractClassPool.this.getClassPoolLogStringForClass(clazz)));
            }
            return clazz;
        }
    }

    private class SearchAllRegisteredLoadersSearchStrategy
    implements ClassPoolSearchStrategy {
        Logger logger = Logger.getLogger(this.getClass());

        private SearchAllRegisteredLoadersSearchStrategy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CtClass getCached(String classname) {
            CtClass clazz;
            boolean trace = this.logger.isTraceEnabled();
            if (trace) {
                this.logger.trace((Object)(this + " " + (Object)((Object)AbstractClassPool.this) + " searching all pools for " + classname));
            }
            if ((clazz = AbstractClassPool.this.getCachedLocally(classname)) == null && AbstractClassPool.this.getClassLoader0() != null && !AbstractClassPool.this.isLocalResource(AbstractClassPool.this.getResourceName(classname), trace) && !AbstractClassPool.this.generatedClasses.containsKey(classname)) {
                Map registeredCLs;
                Map map = registeredCLs = AbstractClassPool.this.repository.getRegisteredCLs();
                synchronized (map) {
                    for (ScopedClassPool pl : registeredCLs.values()) {
                        AbstractClassPool pool = (AbstractClassPool)pl;
                        if (pool.isUnloadedClassLoader()) {
                            if (trace) {
                                this.logger.trace((Object)(this + " pool is unloaded " + (Object)((Object)pool)));
                            }
                            AbstractClassPool.this.repository.unregisterClassLoader(pool.getClassLoader());
                            continue;
                        }
                        if (!pool.includeInGlobalSearch()) {
                            if (!trace) continue;
                            this.logger.trace((Object)(this + " pool is scoped " + (Object)((Object)pool)));
                            continue;
                        }
                        if (trace) {
                            this.logger.trace((Object)(this + " " + (Object)((Object)AbstractClassPool.this) + " searching for " + classname + " in " + (Object)((Object)pool)));
                        }
                        if ((clazz = pool.getCachedLocally(classname)) == null) continue;
                        break;
                    }
                }
            }
            if (trace) {
                this.logger.trace((Object)(this + " " + (Object)((Object)AbstractClassPool.this) + " found " + classname + " in pool" + AbstractClassPool.this.getClassPoolLogStringForClass(clazz)));
            }
            return clazz;
        }
    }

    public static interface ClassPoolSearchStrategy {
        public CtClass getCached(String var1);
    }
}

