/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode.bytes.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.reflect.plugins.bytecode.bytes.asm.ClassReaderCache;
import org.jboss.reflect.plugins.bytecode.bytes.asm.SecurityActions;
import org.jboss.util.CachePolicy;
import org.jboss.util.LRUCachePolicy;
import org.jboss.util.TimedCachePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassReaderCacheFactory {
    private static final Logger log = Logger.getLogger(Logger.class);
    public static final String POLICY_CLASS = "org.jboss.reflect.asm.reader.policy";
    public static final String TIMED_POLICY_LIFETIME = "org.jboss.classpool.policy.lifetime";
    public static final String TIMED_POLICY_RESOLUTION = "org.jboss.classpool.policy.resolution";
    public static final String LRU_POLICY_MIN = "org.jboss.classpool.policy.min";
    public static final String LRU_POLICY_MAX = "org.jboss.classpool.policy.max";
    public static final int DEFAULT_TIMED_POLICY_LIFETIME = 20;
    public static final int DEFAULT_TIMED_POLICY_RESOLUTION = 3;
    public static final int DEFAULT_LRU_POLICY_MIN = 10;
    public static final int DEFAULT_LRU_POLICY_MAX = 100;
    private volatile Class<? extends CachePolicy> policyClass;
    private volatile int lifetime;
    private volatile int resolution;
    private volatile int min;
    private volatile int max;

    ClassReaderCacheFactory() {
    }

    public static ClassReaderCacheFactory createFromProperties() {
        return ClassReaderCacheFactory.createFromProperties(SecurityActions.getSystemProperties());
    }

    public static ClassReaderCacheFactory createFromProperties(Properties properties) {
        ClassReaderCacheFactory initializer = new ClassReaderCacheFactory();
        String policy = properties.getProperty(POLICY_CLASS, null);
        if (policy == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(policy);
            if (!CachePolicy.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException(clazz + " is not an instance of " + CachePolicy.class.getName());
            }
            initializer.policyClass = clazz;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not load policy class " + policy, e);
        }
        if (TimedCachePolicy.class.isAssignableFrom(initializer.policyClass)) {
            initializer.lifetime = ClassReaderCacheFactory.parsePropertyIntoInteger(properties, TIMED_POLICY_LIFETIME, 20);
            initializer.resolution = ClassReaderCacheFactory.parsePropertyIntoInteger(properties, TIMED_POLICY_RESOLUTION, 3);
            ClassReaderCacheFactory.warnUnusedParameters(properties, initializer.policyClass, LRU_POLICY_MIN, LRU_POLICY_MAX);
        } else if (LRUCachePolicy.class.isAssignableFrom(initializer.policyClass)) {
            initializer.min = ClassReaderCacheFactory.parsePropertyIntoInteger(properties, LRU_POLICY_MIN, 10);
            initializer.max = ClassReaderCacheFactory.parsePropertyIntoInteger(properties, LRU_POLICY_MAX, 100);
            ClassReaderCacheFactory.warnUnusedParameters(properties, initializer.policyClass, TIMED_POLICY_LIFETIME, TIMED_POLICY_RESOLUTION);
        } else {
            try {
                Constructor<? extends CachePolicy> ctor = initializer.policyClass.getConstructor(new Class[0]);
                if (!Modifier.isPublic(ctor.getModifiers())) {
                    throw new IllegalStateException("Unknown policy class " + initializer.policyClass.getName() + " has a default constructor, but it is not public");
                }
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Unknown policy class " + initializer.policyClass.getName() + " does not have a default constructor");
            }
        }
        return initializer;
    }

    public ClassReaderCache createCache() {
        TimedCachePolicy policy = null;
        if (this.policyClass == TimedCachePolicy.class) {
            policy = new TimedCachePolicy(this.lifetime, true, this.resolution);
        } else if (this.policyClass == LRUCachePolicy.class) {
            policy = new LRUCachePolicy(this.min, this.max);
        } else {
            try {
                policy = this.policyClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not instantiate " + this.policyClass.getName(), e);
            }
        }
        try {
            policy.create();
            policy.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting domain cache", e);
        }
        return new ClassReaderCache((CachePolicy)policy);
    }

    public Class<? extends CachePolicy> getPolicyClass() {
        return this.policyClass;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public int getResolution() {
        return this.resolution;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    private static int parsePropertyIntoInteger(Properties properties, String key, int defaultValue) {
        try {
            return Integer.valueOf(properties.getProperty(key, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("The value " + properties.getProperty(key) + " for '" + key + "' is not a number");
        }
    }

    private static void warnUnusedParameters(Properties properties, Class<?> clazz, String ... keys) {
        for (String key : keys) {
            if (properties.getProperty(key) == null) continue;
            log.warn((Object)("Ignoring unrecognized property " + key + " for policy class" + clazz));
        }
    }
}

