/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.Set;
import org.jboss.reflect.plugins.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericsUtil {
    public static String getGenericName(Type type) {
        StringBuilder sb = new StringBuilder();
        GenericsUtil.appendTypeGenericInfo(type, sb, null);
        return sb.toString();
    }

    protected static void appendTypeGenericInfo(Type type, StringBuilder sb, Set<String> doneVars) {
        if (type instanceof Class) {
            sb.append(((Class)type).getName());
        } else if (type instanceof WildcardType) {
            WildcardType wtype = (WildcardType)type;
            Type[] lower = wtype.getLowerBounds();
            Type[] upper = wtype.getUpperBounds();
            if (lower.length > 0) {
                GenericsUtil.appendTypeGenericInfo(lower[0], sb, doneVars);
            } else if (upper.length > 0) {
                GenericsUtil.appendTypeGenericInfo(upper[0], sb, doneVars);
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            GenericsUtil.appendTypeGenericInfo(ptype.getRawType(), sb, doneVars);
            StringBuilder params = new StringBuilder();
            params.append("<");
            Type[] types = ptype.getActualTypeArguments();
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    params.append(", ");
                }
                GenericsUtil.appendTypeGenericInfo(types[i], params, doneVars);
            }
            if (params.length() > 1) {
                params.append(">");
                sb.append(params.toString());
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType gtype = (GenericArrayType)type;
            GenericsUtil.appendTypeGenericInfo(gtype.getGenericComponentType(), sb, doneVars);
            sb.append("[]");
        } else if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            if (doneVars == null) {
                doneVars = new HashSet<String>();
            }
            if (!doneVars.contains(typeVar.getName())) {
                doneVars.add(typeVar.getName());
                GenericsUtil.appendTypeGenericInfo(typeVar.getBounds()[0], sb, doneVars);
            }
        } else {
            throw new IllegalArgumentException("Unhandled type " + type.getClass().getName());
        }
    }

    public static ClassLoader findClassLoader(Type type) {
        if (type instanceof Class) {
            return SecurityActions.getClassLoader((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return GenericsUtil.handleNullClassLoader(GenericsUtil.findClassLoader(((ParameterizedType)type).getRawType()));
        }
        if (type instanceof WildcardType) {
            WildcardType wtype = (WildcardType)type;
            if (wtype.getUpperBounds().length > 0) {
                return GenericsUtil.handleNullClassLoader(GenericsUtil.findClassLoader(wtype.getUpperBounds()[0]));
            }
            if (wtype.getLowerBounds().length > 0) {
                return GenericsUtil.handleNullClassLoader(GenericsUtil.findClassLoader(wtype.getLowerBounds()[0]));
            }
        }
        if (type instanceof GenericArrayType) {
            return GenericsUtil.handleNullClassLoader(GenericsUtil.findClassLoader(((GenericArrayType)type).getGenericComponentType()));
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            return GenericsUtil.handleNullClassLoader(GenericsUtil.findClassLoader(typeVar.getBounds()[0]));
        }
        throw new IllegalArgumentException(type.getClass().getName() + " is not handled yet");
    }

    private static ClassLoader handleNullClassLoader(ClassLoader loader) {
        if (loader != null) {
            return loader;
        }
        return SecurityActions.getSystemClassLoader();
    }
}

