/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.types;

import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Date;
import org.jboss.metatype.api.types.AbstractMetaType;
import org.jboss.metatype.api.types.Name;
import org.jboss.metatype.api.types.helpers.BigDecimalComparator;
import org.jboss.metatype.api.types.helpers.BigIntegerComparator;
import org.jboss.metatype.api.types.helpers.BooleanComparator;
import org.jboss.metatype.api.types.helpers.ByteComparator;
import org.jboss.metatype.api.types.helpers.CharacterComparator;
import org.jboss.metatype.api.types.helpers.DateComparator;
import org.jboss.metatype.api.types.helpers.DoubleComparator;
import org.jboss.metatype.api.types.helpers.FloatComparator;
import org.jboss.metatype.api.types.helpers.IntegerComparator;
import org.jboss.metatype.api.types.helpers.LongComparator;
import org.jboss.metatype.api.types.helpers.NamedComparator;
import org.jboss.metatype.api.types.helpers.ShortComparator;
import org.jboss.metatype.api.types.helpers.StringComparator;
import org.jboss.metatype.api.values.SimpleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMetaType
extends AbstractMetaType {
    private static final long serialVersionUID = 6786422588217893696L;
    private transient int cachedHashCode = this.getClassName().hashCode();
    private transient String cachedToString;
    public static final SimpleMetaType BIGDECIMAL = new SimpleMetaType(BigDecimal.class, BigDecimalComparator.INSTANCE);
    public static final SimpleMetaType BIGINTEGER = new SimpleMetaType(BigInteger.class, BigIntegerComparator.INSTANCE);
    public static final SimpleMetaType BOOLEAN = new SimpleMetaType(Boolean.class, BooleanComparator.INSTANCE, 'Z');
    public static final SimpleMetaType BOOLEAN_PRIMITIVE = new SimpleMetaType(Boolean.TYPE, BooleanComparator.INSTANCE, 'Z');
    public static final SimpleMetaType BYTE = new SimpleMetaType(Byte.class, ByteComparator.INSTANCE, 'B');
    public static final SimpleMetaType BYTE_PRIMITIVE = new SimpleMetaType(Byte.TYPE, ByteComparator.INSTANCE, 'B');
    public static final SimpleMetaType CHARACTER = new SimpleMetaType(Character.class, CharacterComparator.INSTANCE, 'C');
    public static final SimpleMetaType CHARACTER_PRIMITIVE = new SimpleMetaType(Character.TYPE, CharacterComparator.INSTANCE, 'C');
    public static final SimpleMetaType DATE = new SimpleMetaType(Date.class, DateComparator.INSTANCE);
    public static final SimpleMetaType DOUBLE = new SimpleMetaType(Double.class, DoubleComparator.INSTANCE, 'D');
    public static final SimpleMetaType DOUBLE_PRIMITIVE = new SimpleMetaType(Double.TYPE, DoubleComparator.INSTANCE, 'D');
    public static final SimpleMetaType FLOAT = new SimpleMetaType(Float.class, FloatComparator.INSTANCE, 'F');
    public static final SimpleMetaType FLOAT_PRIMITIVE = new SimpleMetaType(Float.TYPE, FloatComparator.INSTANCE, 'F');
    public static final SimpleMetaType INTEGER = new SimpleMetaType(Integer.class, IntegerComparator.INSTANCE, 'I');
    public static final SimpleMetaType INTEGER_PRIMITIVE = new SimpleMetaType(Integer.TYPE, IntegerComparator.INSTANCE, 'I');
    public static final SimpleMetaType LONG = new SimpleMetaType(Long.class, LongComparator.INSTANCE, 'J');
    public static final SimpleMetaType LONG_PRIMITIVE = new SimpleMetaType(Long.TYPE, LongComparator.INSTANCE, 'J');
    public static final SimpleMetaType SHORT = new SimpleMetaType(Short.class, ShortComparator.INSTANCE, 'S');
    public static final SimpleMetaType SHORT_PRIMITIVE = new SimpleMetaType(Short.TYPE, ShortComparator.INSTANCE, 'S');
    public static final SimpleMetaType STRING = new SimpleMetaType(String.class, StringComparator.INSTANCE);
    public static final SimpleMetaType NAMEDOBJECT = new SimpleMetaType(Name.class, NamedComparator.INSTANCE);
    public static final SimpleMetaType VOID = new SimpleMetaType(Void.class, null);
    private transient Comparator comparator;
    private transient char primitiveType;

    public static SimpleMetaType resolve(String className) {
        SimpleMetaType result = SimpleMetaType.isSimpleType(className);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Class is not a simple type: " + className);
    }

    public static SimpleMetaType isSimpleType(String className) {
        if (className == null) {
            throw new IllegalArgumentException("Null class name");
        }
        if (className.equals(STRING.getClassName())) {
            return STRING;
        }
        if (className.equals(INTEGER.getClassName())) {
            return INTEGER;
        }
        if (className.equals(Integer.TYPE.getName())) {
            return INTEGER_PRIMITIVE;
        }
        if (className.equals(BOOLEAN.getClassName())) {
            return BOOLEAN;
        }
        if (className.equals(Boolean.TYPE.getName())) {
            return BOOLEAN_PRIMITIVE;
        }
        if (className.equals(LONG.getClassName())) {
            return LONG;
        }
        if (className.equals(Long.TYPE.getName())) {
            return LONG_PRIMITIVE;
        }
        if (className.equals(BYTE.getClassName())) {
            return BYTE;
        }
        if (className.equals(Byte.TYPE.getName())) {
            return BYTE_PRIMITIVE;
        }
        if (className.equals(CHARACTER.getClassName())) {
            return CHARACTER;
        }
        if (className.equals(Character.TYPE.getName())) {
            return CHARACTER_PRIMITIVE;
        }
        if (className.equals(DOUBLE.getClassName())) {
            return DOUBLE;
        }
        if (className.equals(Double.TYPE.getName())) {
            return DOUBLE_PRIMITIVE;
        }
        if (className.equals(FLOAT.getClassName())) {
            return FLOAT;
        }
        if (className.equals(Float.TYPE.getName())) {
            return FLOAT_PRIMITIVE;
        }
        if (className.equals(SHORT.getClassName())) {
            return SHORT;
        }
        if (className.equals(Short.TYPE.getName())) {
            return SHORT_PRIMITIVE;
        }
        if (className.equals(BIGDECIMAL.getClassName())) {
            return BIGDECIMAL;
        }
        if (className.equals(BIGINTEGER.getClassName())) {
            return BIGINTEGER;
        }
        if (className.equals(VOID.getClassName()) || className.equals(Void.TYPE.getName())) {
            return VOID;
        }
        if (className.equals(DATE.getClassName())) {
            return DATE;
        }
        if (className.equals(NAMEDOBJECT.getClassName())) {
            return NAMEDOBJECT;
        }
        return null;
    }

    private SimpleMetaType(String className) {
        super(className);
        StringBuilder buffer = new StringBuilder(SimpleMetaType.class.getSimpleName());
        buffer.append(":");
        buffer.append(this.getClassName());
        this.cachedToString = buffer.toString();
    }

    private <T> SimpleMetaType(Class<T> clazz, Comparator<T> comparator) {
        this(clazz, comparator, '\u0000');
    }

    private <T> SimpleMetaType(Class<T> clazz, Comparator<T> comparator, char primitiveType) {
        this(clazz.getName());
        this.comparator = comparator;
        this.primitiveType = primitiveType;
    }

    public int compare(Object first, Object second) {
        if (this.comparator == null) {
            return 0;
        }
        if (first == null || second == null) {
            throw new IllegalArgumentException("Null objects to compare.");
        }
        return this.comparator.compare(first, second);
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public boolean isPrimitive() {
        return this.primitiveType != '\u0000' && !this.getTypeName().startsWith("java.lang");
    }

    @Override
    public boolean isValue(Object obj) {
        if (obj == null || !(obj instanceof SimpleValue)) {
            return false;
        }
        SimpleValue value = (SimpleValue)obj;
        return this.equals(value.getMetaType());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SimpleMetaType)) {
            return false;
        }
        SimpleMetaType other = (SimpleMetaType)obj;
        return this.getClassName().equals(other.getClassName());
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public String toString() {
        return this.cachedToString;
    }

    public boolean equalsIgnorePrimitive(Object obj) {
        if (obj == null || !(obj instanceof SimpleMetaType)) {
            return false;
        }
        SimpleMetaType other = (SimpleMetaType)obj;
        return this.primitiveType == other.primitiveType;
    }

    private Object readResolve() throws ObjectStreamException {
        return SimpleMetaType.resolve(this.getClassName());
    }
}

