/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.persistent;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.web.tomcat.service.session.persistent.RDBMSStoreBase;

public class DriverManagerPersistentStore
extends RDBMSStoreBase {
    private static final String storeName = DriverManagerPersistentStore.class.getSimpleName();
    private static final String info = storeName + "/1.0";
    private String connectionURL = null;
    private Lock lock = new ReentrantLock();
    private volatile Connection dbConnection = null;
    private Driver driver = null;
    private String driverName = null;

    public String getStoreName() {
        return storeName;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    protected Connection getConnection() throws SQLException {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while acquiring connection lock");
        }
        if (this.dbConnection == null) {
            this.open();
        }
        return this.dbConnection;
    }

    protected void cleanup(Connection conn, ResultSet resultSet, boolean rollback) {
        this.dbConnection = null;
        super.cleanup(conn, resultSet, rollback);
    }

    protected void releaseConnection(Connection dbConnection) {
        this.lock.unlock();
    }

    public String getInfo() {
        return info;
    }

    protected void startStore() {
        try {
            Class<?> clazz = Class.forName(this.driverName);
            this.driver = (Driver)clazz.newInstance();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Caught exception creating driver of class " + this.driverName, ex);
        }
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while acquiring connection lock");
        }
        try {
            this.open();
        }
        catch (SQLException e) {
            throw new RuntimeException("Caught SQLException while opening database connection -- " + e.toString());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection open() throws SQLException {
        DriverManagerPersistentStore driverManagerPersistentStore = this;
        synchronized (driverManagerPersistentStore) {
            if (this.dbConnection != null) {
                return this.dbConnection;
            }
            Properties props = new Properties();
            if (this.getConnectionName() != null) {
                props.put("user", this.getConnectionName());
            }
            if (this.getConnectionPassword() != null) {
                props.put("password", this.getConnectionPassword());
            }
            this.dbConnection = this.driver.connect(this.connectionURL, props);
            this.dbConnection.setAutoCommit(true);
            return this.dbConnection;
        }
    }
}

