/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.decorators;

import java.io.ObjectInput;
import java.util.List;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.AbstractDelegatingStore;
import org.infinispan.loaders.modifications.Modification;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ReadOnlyStore
extends AbstractDelegatingStore {
    private static final Log log = LogFactory.getLog(ReadOnlyStore.class);

    public ReadOnlyStore(CacheStore delegate) {
        super(delegate);
    }

    @Override
    public void store(InternalCacheEntry ed) {
        if (log.isTraceEnabled()) {
            log.trace("Ignoring store invocation");
        }
    }

    @Override
    public void fromStream(ObjectInput inputStream) {
        if (log.isTraceEnabled()) {
            log.trace("Ignoring writing contents of stream to store");
        }
    }

    @Override
    public void clear() {
        if (log.isTraceEnabled()) {
            log.trace("Ignoring clear invocation");
        }
    }

    @Override
    public boolean remove(Object key) {
        if (log.isTraceEnabled()) {
            log.trace("Ignoring removal of key");
        }
        return false;
    }

    @Override
    public void purgeExpired() {
        if (log.isTraceEnabled()) {
            log.trace("Ignoring purge expired invocation");
        }
    }

    @Override
    public void commit(GlobalTransaction tx) {
        if (log.isTraceEnabled()) {
            log.trace("Ignoring transactional commit call");
        }
    }

    @Override
    public void rollback(GlobalTransaction tx) {
        if (log.isTraceEnabled()) {
            log.trace("Ignoring transactional rollback call");
        }
    }

    @Override
    public void prepare(List<? extends Modification> list, GlobalTransaction tx, boolean isOnePhase) {
        if (log.isTraceEnabled()) {
            log.trace("Ignoring transactional prepare call");
        }
    }
}

