/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.policy.deployer;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.ws.policy.AndCompositeAssertion;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.policy.XorCompositeAssertion;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.extensions.addressing.policy.AddressingPolicyAssertionDeployer;
import org.jboss.ws.extensions.policy.deployer.domainAssertion.AssertionDeployer;
import org.jboss.ws.extensions.policy.deployer.domainAssertion.NopAssertionDeployer;
import org.jboss.ws.extensions.policy.deployer.domainAssertion.WSSecurityAssertionDeployer;
import org.jboss.ws.extensions.policy.deployer.exceptions.UnsupportedAlternative;
import org.jboss.ws.extensions.policy.deployer.exceptions.UnsupportedAssertion;
import org.jboss.ws.extensions.policy.deployer.exceptions.UnsupportedPolicy;
import org.jboss.ws.extensions.wsrm.policy.RM10PolicyAssertionDeployer;
import org.jboss.ws.extensions.wsrm.policy.RM11PolicyAssertionDeployer;
import org.jboss.ws.metadata.umdm.ExtensibleMetaData;

public class PolicyDeployer {
    private static final Logger log = Logger.getLogger(PolicyDeployer.class);
    private static PolicyDeployer me = new PolicyDeployer();
    private Map<String, Class> domainDeployerMap = new HashMap<String, Class>();

    PolicyDeployer() {
    }

    public static PolicyDeployer getInstance() {
        return me;
    }

    public static PolicyDeployer newInstance(Map<String, Class> customDomainMap) {
        PolicyDeployer instance = new PolicyDeployer();
        instance.domainDeployerMap = customDomainMap;
        return instance;
    }

    public static PolicyDeployer newInstanceForTools() {
        PolicyDeployer instance = new PolicyDeployer();
        instance.domainDeployerMap.put("http://www.jboss.com/ws-security/schema/jboss-ws-security_1_0.xsd", NopAssertionDeployer.class);
        instance.domainDeployerMap.put("http://docs.oasis-open.org/ws-rx/wsrmp/200702", NopAssertionDeployer.class);
        instance.domainDeployerMap.put("http://schemas.xmlsoap.org/ws/2005/02/rm/policy", NopAssertionDeployer.class);
        instance.domainDeployerMap.put("http://www.w3.org/2006/05/addressing/wsdl", NopAssertionDeployer.class);
        instance.domainDeployerMap.put("http://www.w3.org/2007/05/addressing/metadata", NopAssertionDeployer.class);
        return instance;
    }

    public Policy deployServerside(Policy policy, ExtensibleMetaData extMetaData) throws UnsupportedPolicy {
        if (policy == null) {
            throw new WSException("Cannot deploy null policy!");
        }
        LinkedList<AndCompositeAssertion> returnedPolicyTerms = new LinkedList<AndCompositeAssertion>();
        if (!policy.isNormalized()) {
            policy = (Policy)policy.normalize();
        }
        XorCompositeAssertion exactlyOne = (XorCompositeAssertion)policy.getTerms().get(0);
        log.debug((Object)("####" + exactlyOne.getClass()));
        log.debug((Object)("####" + exactlyOne.getTerms()));
        for (AndCompositeAssertion alternative : exactlyOne.getTerms()) {
            log.debug((Object)"alternative");
            try {
                this.deployAlternativeServerSide(alternative, extMetaData);
                returnedPolicyTerms.add(alternative);
            }
            catch (UnsupportedAlternative e) {
                log.debug((Object)"Unsupported Alternative");
            }
        }
        if (returnedPolicyTerms.size() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"XorComposite zero element...Policy not supported");
            }
            throw new UnsupportedPolicy();
        }
        policy.getTerms().clear();
        policy.addTerms(returnedPolicyTerms);
        return policy;
    }

    public void deployClientSide(Policy policy, ExtensibleMetaData extMetaData) throws UnsupportedPolicy {
        if (policy == null) {
            throw new WSException("Cannot deploy null policy!");
        }
        if (!policy.isNormalized()) {
            policy = (Policy)policy.normalize();
        }
        XorCompositeAssertion exactlyOne = (XorCompositeAssertion)policy.getTerms().get(0);
        for (AndCompositeAssertion alternative : exactlyOne.getTerms()) {
            for (Assertion assertion : alternative.getTerms()) {
                if (assertion instanceof PrimitiveAssertion) {
                    try {
                        this.deployAssertionClientSide((PrimitiveAssertion)assertion, extMetaData);
                        continue;
                    }
                    catch (UnsupportedAssertion e) {
                        log.error((Object)"Unsupported assertion!");
                        throw new UnsupportedPolicy();
                    }
                }
                if (!(assertion instanceof Policy)) continue;
                this.deployClientSide((Policy)assertion, extMetaData);
            }
        }
    }

    private void deployAlternativeServerSide(AndCompositeAssertion alternative, ExtensibleMetaData extMetaData) throws UnsupportedAlternative {
        for (Assertion assertion : alternative.getTerms()) {
            try {
                if (assertion instanceof PrimitiveAssertion) {
                    this.deployAssertionServerSide((PrimitiveAssertion)assertion, extMetaData);
                    continue;
                }
                if (assertion instanceof Policy) {
                    this.deployServerside((Policy)assertion, extMetaData);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unknown Alternative type....Alternative not supported");
                }
                throw new UnsupportedAlternative();
            }
            catch (UnsupportedAssertion e) {
                throw new UnsupportedAlternative();
            }
            catch (UnsupportedPolicy ep) {
                throw new UnsupportedAlternative();
            }
        }
    }

    private void deployAssertionServerSide(PrimitiveAssertion assertion, ExtensibleMetaData extMetaData) throws UnsupportedAssertion {
        AssertionDeployer deployer = this.getDomainDeployerInstance(assertion.getName().getNamespaceURI());
        deployer.deployServerSide(assertion, extMetaData);
    }

    private void deployAssertionClientSide(PrimitiveAssertion assertion, ExtensibleMetaData extMetaData) throws UnsupportedAssertion {
        AssertionDeployer deployer = this.getDomainDeployerInstance(assertion.getName().getNamespaceURI());
        deployer.deployClientSide(assertion, extMetaData);
    }

    private AssertionDeployer getDomainDeployerInstance(String namespace) throws UnsupportedAssertion {
        try {
            if (!this.domainDeployerMap.containsKey(namespace)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Unknown namespace:" + namespace + "...Assertion not supported"));
                }
                throw new UnsupportedAssertion();
            }
            return (AssertionDeployer)this.domainDeployerMap.get(namespace).newInstance();
        }
        catch (Exception e) {
            throw new UnsupportedAssertion();
        }
    }

    static {
        PolicyDeployer.me.domainDeployerMap.put("http://www.jboss.com/ws-security/schema/jboss-ws-security_1_0.xsd", WSSecurityAssertionDeployer.class);
        PolicyDeployer.me.domainDeployerMap.put("http://docs.oasis-open.org/ws-rx/wsrmp/200702", RM11PolicyAssertionDeployer.class);
        PolicyDeployer.me.domainDeployerMap.put("http://schemas.xmlsoap.org/ws/2005/02/rm/policy", RM10PolicyAssertionDeployer.class);
        PolicyDeployer.me.domainDeployerMap.put("http://www.w3.org/2007/05/addressing/metadata", AddressingPolicyAssertionDeployer.class);
        PolicyDeployer.me.domainDeployerMap.put("http://www.w3.org/2006/05/addressing/wsdl", NopAssertionDeployer.class);
    }
}

