/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.soap.EnvelopeBuilder;
import org.jboss.ws.core.soap.FastInfosetEnvelopeBuilder;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.SOAPEnvelopeImpl;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.core.soap.SOAPPartImpl;
import org.jboss.ws.core.soap.Style;
import org.jboss.ws.core.soap.attachment.MultipartRelatedDecoder;
import org.jboss.ws.feature.FastInfosetFeature;
import org.jboss.ws.metadata.umdm.FeatureSet;
import org.jboss.wsf.common.IOUtils;
import org.jboss.wsf.spi.util.ServiceLoader;

public class MessageFactoryImpl
extends MessageFactory {
    private static Logger log = Logger.getLogger(MessageFactoryImpl.class);
    private String envNamespace;
    private Service.Mode serviceMode;
    private Style style;
    private FeatureSet features = new FeatureSet();
    private boolean dynamic;

    public MessageFactoryImpl() {
        this.envNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
    }

    public MessageFactoryImpl(String protocol) throws SOAPException {
        if ("SOAP 1.1 Protocol".equals(protocol) || "SOAP 1.1 Protocol".equals(protocol)) {
            this.envNamespace = "http://schemas.xmlsoap.org/soap/envelope/";
        } else if ("SOAP 1.2 Protocol".equals(protocol)) {
            this.envNamespace = "http://www.w3.org/2003/05/soap-envelope";
        } else if ("Dynamic Protocol".equals(protocol)) {
            this.dynamic = true;
        } else {
            throw new SOAPException("Unknown protocol: " + protocol);
        }
    }

    public String getEnvNamespace() {
        return this.envNamespace;
    }

    public void setEnvNamespace(String envelopeURI) {
        this.envNamespace = envelopeURI;
    }

    public Style getStyle() {
        if (this.style == null) {
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext != null && msgContext.getOperationMetaData() != null) {
                this.style = msgContext.getOperationMetaData().getStyle();
            }
            log.trace((Object)("Using style: " + this.style));
        }
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Service.Mode getServiceMode() {
        return this.serviceMode;
    }

    public void setServiceMode(Service.Mode serviceMode) {
        this.serviceMode = serviceMode;
    }

    public void addFeature(WebServiceFeature feature) {
        this.features.addFeature(feature);
    }

    public void setFeatures(FeatureSet features) {
        this.features = features;
    }

    public SOAPMessage createMessage() throws SOAPException {
        if (this.dynamic) {
            throw new UnsupportedOperationException("Cannot create default message when protocol is dynamic");
        }
        SOAPMessageImpl soapMessage = new SOAPMessageImpl();
        SOAPPartImpl soapPart = (SOAPPartImpl)soapMessage.getSOAPPart();
        new SOAPEnvelopeImpl(soapPart, this.envNamespace, true);
        return soapMessage;
    }

    public SOAPMessage createMessage(MimeHeaders mimeHeaders, InputStream ins) throws IOException, SOAPException {
        return this.createMessage(mimeHeaders, ins, false);
    }

    public SOAPMessage createMessage(MimeHeaders mimeHeaders, InputStream inputStream, boolean ignoreParseError) throws IOException, SOAPException {
        if (mimeHeaders == null) {
            mimeHeaders = new MimeHeaders();
        } else if (log.isTraceEnabled()) {
            Iterator itMimeHeaders = mimeHeaders.getAllHeaders();
            while (itMimeHeaders.hasNext()) {
                MimeHeader mh = (MimeHeader)itMimeHeaders.next();
                log.trace((Object)mh);
            }
        }
        ContentType contentType = MessageFactoryImpl.getContentType(mimeHeaders);
        if (log.isDebugEnabled()) {
            log.debug((Object)("createMessage: [contentType=" + contentType + "]"));
        }
        SOAPMessageImpl soapMessage = new SOAPMessageImpl();
        String encoding = contentType.getParameterList().get("charset");
        if (encoding != null) {
            soapMessage.setProperty("javax.xml.soap.character-set-encoding", encoding);
        }
        if (inputStream != null) {
            if (log.isTraceEnabled()) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                IOUtils.copyStream((OutputStream)baos, (InputStream)inputStream);
                byte[] bytes = baos.toByteArray();
                log.trace((Object)("createMessage\n" + new String(bytes)));
                inputStream = new ByteArrayInputStream(bytes);
            }
            Collection<AttachmentPart> attachments = null;
            if (this.isMultipartRelatedContent(contentType)) {
                MultipartRelatedDecoder decoder;
                try {
                    decoder = new MultipartRelatedDecoder(contentType);
                    decoder.decodeMultipartRelatedMessage(inputStream);
                }
                catch (RuntimeException rte) {
                    throw rte;
                }
                catch (IOException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new SOAPException("Cannot decode multipart related message", (Throwable)ex);
                }
                inputStream = decoder.getRootPart().getDataHandler().getInputStream();
                attachments = decoder.getRelatedParts();
                if (this.isXOPContent(contentType)) {
                    soapMessage.setXOPMessage(true);
                }
            } else if (this.isFastInfosetContent(contentType)) {
                if (!this.features.isFeatureEnabled(FastInfosetFeature.class)) {
                    throw new SOAPException("FastInfoset support is not enabled, use FastInfosetFeature to enable it.");
                }
            } else if (!this.isSoapContent(contentType)) {
                throw new SOAPException("Unsupported content type: " + contentType);
            }
            if (mimeHeaders != null) {
                soapMessage.setMimeHeaders(mimeHeaders);
            }
            if (attachments != null) {
                soapMessage.setAttachments(attachments);
            }
            EnvelopeBuilder envBuilder = this.features.isFeatureEnabled(FastInfosetFeature.class) ? new FastInfosetEnvelopeBuilder() : (EnvelopeBuilder)ServiceLoader.loadService((String)EnvelopeBuilder.class.getName(), null);
            if (inputStream.markSupported()) {
                inputStream.mark(1);
                int bytesRead = inputStream.read(new byte[1]);
                inputStream.reset();
                if (bytesRead == -1) {
                    return soapMessage;
                }
            }
            envBuilder.setStyle(this.getStyle());
            envBuilder.build((SOAPMessage)soapMessage, inputStream, ignoreParseError);
        }
        return soapMessage;
    }

    private static ContentType getContentType(MimeHeaders headers) throws SOAPException {
        ContentType contentType = null;
        try {
            String[] type = headers.getHeader("Content-Type");
            contentType = type != null ? new ContentType(type[0]) : new ContentType("text/xml");
            return contentType;
        }
        catch (ParseException e) {
            throw new SOAPException("Could not parse content type:" + (Object)((Object)e));
        }
    }

    private boolean isSoapContent(ContentType type) {
        String baseType = type.getBaseType();
        return "text/xml".equalsIgnoreCase(baseType) || "application/soap+xml".equalsIgnoreCase(baseType);
    }

    private boolean isFastInfosetContent(ContentType type) {
        String baseType = type.getBaseType();
        return "application/fastinfoset".equalsIgnoreCase(baseType);
    }

    private boolean isMultipartRelatedContent(ContentType type) {
        String baseType = type.getBaseType();
        return "multipart/related".equalsIgnoreCase(baseType);
    }

    private boolean isXOPContent(ContentType type) {
        String paramType = type.getParameter("type");
        return "application/xop+xml".endsWith(paramType);
    }
}

