/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.CommonBinding;
import org.jboss.ws.core.CommonBindingProvider;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.EndpointInvocation;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.server.ServiceEndpointInvoker;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.HandlerCallback;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public class ServiceEndpointInvokerEJB21
extends ServiceEndpointInvoker {
    private static final Logger log = Logger.getLogger(ServiceEndpointInvokerEJB21.class);

    @Override
    protected Invocation setupInvocation(Endpoint ep, EndpointInvocation epInv, InvocationContext invContext) throws Exception {
        Invocation inv = super.setupInvocation(ep, epInv, invContext);
        ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)this.endpoint.getAttachment(ServerEndpointMetaData.class);
        invContext.addAttachment(HandlerCallback.class, (Object)new HandlerCallbackImpl(sepMetaData));
        return inv;
    }

    @Override
    public boolean callRequestHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type) {
        if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
            return this.delegate.callRequestHandlerChain(sepMetaData, type);
        }
        return true;
    }

    @Override
    public boolean callResponseHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type) {
        if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
            return this.delegate.callResponseHandlerChain(sepMetaData, type);
        }
        return true;
    }

    @Override
    public boolean callFaultHandlerChain(ServerEndpointMetaData sepMetaData, UnifiedHandlerMetaData.HandlerType type, Exception ex) {
        if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
            return this.delegate.callFaultHandlerChain(sepMetaData, type, ex);
        }
        return true;
    }

    public class HandlerCallbackImpl
    implements HandlerCallback {
        private ServerEndpointMetaData sepMetaData;

        public HandlerCallbackImpl(ServerEndpointMetaData sepMetaData) {
            this.sepMetaData = sepMetaData;
        }

        public boolean callRequestHandlerChain(Invocation wsInv, UnifiedHandlerMetaData.HandlerType type) {
            boolean handlerPass = true;
            if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT) {
                handlerPass = ServiceEndpointInvokerEJB21.this.delegate.callRequestHandlerChain(this.sepMetaData, type);
            } else if (type == UnifiedHandlerMetaData.HandlerType.POST) {
                handlerPass = ServiceEndpointInvokerEJB21.this.delegate.callRequestHandlerChain(this.sepMetaData, type);
                CommonMessageContext messageContext = MessageContextAssociation.peekMessageContext();
                if (handlerPass && messageContext.isModified()) {
                    try {
                        OperationMetaData opMetaData = messageContext.getOperationMetaData();
                        CommonBindingProvider bindingProvider = new CommonBindingProvider(opMetaData.getEndpointMetaData());
                        CommonBinding binding = bindingProvider.getCommonBinding();
                        log.debug((Object)"Handler modified payload, unbind message and update invocation args");
                        EndpointInvocation epInv = binding.unbindRequestMessage(opMetaData, messageContext.getMessageAbstraction());
                        wsInv.getInvocationContext().addAttachment(EndpointInvocation.class, (Object)epInv);
                    }
                    catch (BindingException ex) {
                        throw new WSException(ex);
                    }
                }
            }
            return handlerPass;
        }

        public boolean callResponseHandlerChain(Invocation wsInv, UnifiedHandlerMetaData.HandlerType type) {
            if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
                return true;
            }
            return ServiceEndpointInvokerEJB21.this.delegate.callResponseHandlerChain(this.sepMetaData, type);
        }

        public boolean callFaultHandlerChain(Invocation wsInv, UnifiedHandlerMetaData.HandlerType type, Exception ex) {
            if (type == UnifiedHandlerMetaData.HandlerType.PRE) {
                return true;
            }
            return ServiceEndpointInvokerEJB21.this.delegate.callFaultHandlerChain(this.sepMetaData, type, ex);
        }
    }
}

