/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.http.interfaces;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
import org.jboss.ha.framework.interfaces.FamilyClusterInfo;
import org.jboss.ha.framework.interfaces.GenericClusteringException;
import org.jboss.ha.framework.interfaces.HARMIResponse;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationException;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.InvokerProxyHA;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.invocation.PayloadKey;
import org.jboss.invocation.ServiceUnavailableException;
import org.jboss.invocation.http.interfaces.Util;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.TransactionPropagationContextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpInvokerProxyHA
implements InvokerProxyHA,
Invoker,
Externalizable {
    private static Logger log = Logger.getLogger(HttpInvokerProxyHA.class);
    private static final long serialVersionUID = -7081220026780794383L;
    public static final Map<Object, Object> txFailoverAuthorizations = Collections.synchronizedMap(new WeakHashMap());
    protected LoadBalancePolicy loadBalancePolicy;
    protected String proxyFamilyName = null;
    protected FamilyClusterInfo familyClusterInfo = null;
    protected transient boolean trace = false;

    public HttpInvokerProxyHA() {
    }

    public HttpInvokerProxyHA(List targets, long viewId, LoadBalancePolicy policy, String proxyFamilyName) {
        this.familyClusterInfo = ClusteringTargetsRepository.initTarget((String)proxyFamilyName, (List)targets, (long)viewId);
        this.loadBalancePolicy = policy;
        this.proxyFamilyName = proxyFamilyName;
        this.trace = log.isTraceEnabled();
        if (this.trace) {
            log.trace((Object)("Init, cluterInfo: " + this.familyClusterInfo + ", policy=" + this.loadBalancePolicy));
        }
    }

    @Override
    public void updateClusterInfo(List<?> targets, long viewId) {
        if (this.familyClusterInfo != null) {
            this.familyClusterInfo.updateClusterInfo(targets, viewId);
        }
    }

    public String getServerHostName() throws Exception {
        return null;
    }

    @Override
    public FamilyClusterInfo getFamilyClusterInfo() {
        return this.familyClusterInfo;
    }

    @Override
    public void forbidTransactionFailover(Object tpc) {
        txFailoverAuthorizations.put(tpc, null);
    }

    public String getProxyFamilyName() {
        return this.proxyFamilyName;
    }

    public Object getRemoteTarget() {
        return this.getRemoteTarget(null);
    }

    public Object getRemoteTarget(Invocation invocationBasedRouting) {
        Object target = this.loadBalancePolicy.chooseTarget(this.familyClusterInfo, invocationBasedRouting);
        if (this.trace) {
            log.trace((Object)("Choose remoteTarget: " + target));
        }
        return target;
    }

    public void remoteTargetHasFailed(Object target) {
        this.removeDeadTarget(target);
    }

    protected int totalNumberOfTargets() {
        int size = 0;
        if (this.familyClusterInfo != null) {
            size = this.familyClusterInfo.getTargets().size();
        }
        return size;
    }

    protected void removeDeadTarget(Object target) {
        if (this.familyClusterInfo != null) {
            List targets = this.familyClusterInfo.removeDeadTarget(target);
            if (this.trace) {
                log.trace((Object)("removeDeadTarget(" + target + "), targets.size=" + targets.size()));
            }
        }
    }

    protected void resetView() {
        this.familyClusterInfo.resetView();
    }

    public Object invoke(Invocation invocation) throws Exception {
        int failoverCounter = 0;
        MarshalledInvocation mi = new MarshalledInvocation(invocation);
        mi.setValue((Object)"CLUSTER_VIEW_ID", (Object)new Long(this.familyClusterInfo.getCurrentViewId()));
        String target = (String)this.getRemoteTarget(invocation);
        boolean failoverAuthorized = true;
        URL externalURL = Util.resolveURL((String)target);
        IOException lastException = null;
        while (externalURL != null && failoverAuthorized) {
            boolean definitivelyRemoveNodeOnFailure = true;
            invocation.setValue((Object)"FAILOVER_COUNTER", (Object)new Integer(failoverCounter), PayloadKey.AS_IS);
            try {
                if (this.trace) {
                    log.trace((Object)("Invoking on target=" + externalURL));
                }
                Object rtn = Util.invoke((URL)externalURL, (Invocation)mi);
                HARMIResponse rsp = (HARMIResponse)rtn;
                if (rsp.newReplicants != null) {
                    this.updateClusterInfo(rsp.newReplicants, rsp.currentViewId);
                }
                this.invocationHasReachedAServer(invocation);
                return rsp.response;
            }
            catch (GenericClusteringException e) {
                definitivelyRemoveNodeOnFailure = this.handleGenericClusteringException(invocation, failoverCounter, definitivelyRemoveNodeOnFailure, e);
            }
            catch (InvocationException e) {
                Throwable cause = e.getTargetException();
                if (cause instanceof GenericClusteringException) {
                    GenericClusteringException gce = (GenericClusteringException)cause;
                    definitivelyRemoveNodeOnFailure = this.handleGenericClusteringException(invocation, failoverCounter, definitivelyRemoveNodeOnFailure, gce);
                }
                this.invocationHasReachedAServer(invocation);
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new InvocationTargetException(cause);
            }
            catch (ConnectException e) {
                lastException = e;
            }
            catch (UnknownHostException e) {
                lastException = e;
            }
            catch (Exception e) {
                if (this.trace) {
                    log.trace((Object)("Invoke failed, target=" + externalURL), (Throwable)e);
                }
                this.invocationHasReachedAServer(invocation);
                throw e;
            }
            this.remoteTargetHasFailed(target);
            if (definitivelyRemoveNodeOnFailure) {
                this.resetView();
            }
            failoverAuthorized = this.txContextAllowsFailover(invocation);
            target = (String)this.getRemoteTarget(invocation);
            externalURL = Util.resolveURL((String)target);
            ++failoverCounter;
        }
        String msg = failoverAuthorized ? "Service unavailable." : "Service unavailable (failover not possible inside a user transaction).";
        throw new ServiceUnavailableException(msg, lastException);
    }

    private boolean handleGenericClusteringException(Invocation invocation, int failoverCounter, boolean definitivlyRemoveNodeOnFailure, GenericClusteringException gce) throws ServerException {
        if (gce.getCompletionStatus() == 1) {
            if (this.totalNumberOfTargets() >= failoverCounter && !gce.isDefinitive()) {
                definitivlyRemoveNodeOnFailure = false;
            }
        } else {
            this.invocationHasReachedAServer(invocation);
            throw new ServerException("Clustering error", (Exception)((Object)gce));
        }
        return definitivlyRemoveNodeOnFailure;
    }

    public void invocationHasReachedAServer(Invocation invocation) {
        Object tpc = this.getTransactionPropagationContext();
        if (tpc != null) {
            this.forbidTransactionFailover(tpc);
        }
    }

    public Object getTransactionPropagationContext() {
        TransactionPropagationContextFactory tpcFactory = TransactionPropagationContextUtil.getTPCFactoryClientSide();
        return tpcFactory == null ? null : tpcFactory.getTransactionPropagationContext();
    }

    public boolean txContextAllowsFailover(Invocation invocation) {
        Object tpc = this.getTransactionPropagationContext();
        if (tpc != null) {
            if (this.trace) {
                log.trace((Object)("Checking tx failover authorisation map with tpc " + tpc));
            }
            return !txFailoverAuthorizations.containsKey(tpc);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ArrayList currentTargets = null;
        long vid = 0L;
        FamilyClusterInfo familyClusterInfo = this.familyClusterInfo;
        synchronized (familyClusterInfo) {
            currentTargets = new ArrayList(this.familyClusterInfo.getTargets());
            vid = this.familyClusterInfo.getCurrentViewId();
        }
        out.writeObject(currentTargets);
        out.writeLong(vid);
        out.writeObject(this.loadBalancePolicy);
        out.writeObject(this.proxyFamilyName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        List targets = (List)in.readObject();
        long vid = in.readLong();
        this.loadBalancePolicy = (LoadBalancePolicy)in.readObject();
        this.proxyFamilyName = (String)in.readObject();
        this.trace = log.isTraceEnabled();
        this.familyClusterInfo = ClusteringTargetsRepository.initTarget((String)this.proxyFamilyName, (List)targets, (long)vid);
        if (this.trace) {
            log.trace((Object)("Init, clusterInfo: " + this.familyClusterInfo + ", policy=" + this.loadBalancePolicy));
        }
    }
}

