/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.bean.mc.deployer;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.injection.injector.EEInjector;
import org.jboss.injection.injector.metadata.EnvironmentEntryType;
import org.jboss.injection.injector.metadata.JndiEnvironmentRefsGroup;
import org.jboss.injection.manager.spi.InjectionManager;
import org.jboss.injection.manager.spi.Injector;
import org.jboss.injection.mc.metadata.JndiEnvironmentImpl;
import org.jboss.logging.Logger;
import org.jboss.managed.bean.impl.manager.ManagedBeanManagerImpl;
import org.jboss.managed.bean.mc.util.ManagedBeanMCBeanUtil;
import org.jboss.managed.bean.metadata.ManagedBeanDeploymentMetaData;
import org.jboss.managed.bean.metadata.ManagedBeanMetaData;
import org.jboss.managed.bean.metadata.jbmeta.ManagedBeanMetaDataImpl;
import org.jboss.managed.bean.spi.ManagedBeanManager;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;
import org.jboss.switchboard.spi.Barrier;

public class ManagedBeanManagerDeployer
extends AbstractDeployer {
    private static Logger logger = Logger.getLogger(ManagedBeanManagerDeployer.class);
    private JavaEEComponentInformer javaeeComponentInformer;

    public ManagedBeanManagerDeployer() {
        this.setStage(DeploymentStages.REAL);
        this.setInput(ManagedBeanDeploymentMetaData.class);
        this.addInput(Barrier.class);
        this.setOutput(BeanMetaData.class);
    }

    @Inject
    public void setJavaEEComponentInformer(JavaEEComponentInformer componentInformer) {
        this.javaeeComponentInformer = componentInformer;
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        ManagedBeanDeploymentMetaData managedBeanDeployment = (ManagedBeanDeploymentMetaData)unit.getAttachment(ManagedBeanDeploymentMetaData.class);
        Collection managedBeans = managedBeanDeployment.getManagedBeans();
        if (managedBeans == null || managedBeans.isEmpty()) {
            return;
        }
        for (ManagedBeanMetaData managedBean : managedBeans) {
            this.deploy(unit, managedBean);
        }
    }

    private void deploy(DeploymentUnit unit, ManagedBeanMetaData managedBean) throws DeploymentException {
        Class<?> beanClass;
        try {
            beanClass = this.getBeanClass(unit, managedBean);
        }
        catch (ClassNotFoundException cnfe) {
            throw new DeploymentException("Could not load managed bean class " + managedBean.getManagedBeanClass() + " in unit " + unit, (Throwable)cnfe);
        }
        InjectionManager injectionManager = (InjectionManager)unit.getAttachment(InjectionManager.class);
        String managedBeanManagerMCBeanName = ManagedBeanMCBeanUtil.getManagedBeanManagerMCBeanName(this.javaeeComponentInformer, unit, managedBean);
        ManagedBeanManagerImpl managedBeanManager = new ManagedBeanManagerImpl(beanClass, managedBean, injectionManager);
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)managedBeanManagerMCBeanName, (String)ManagedBeanManagerImpl.class.getName());
        builder.setConstructorValue((Object)managedBeanManager);
        Barrier switchboard = (Barrier)unit.getAttachment(Barrier.class);
        logger.debug((Object)("Adding switchboard dependency: " + switchboard.getId() + " for managed bean manager: " + managedBeanManagerMCBeanName + " in unit " + unit));
        builder.addDependency((Object)switchboard.getId());
        Set<String> injectors = this.setupInjectors(unit, (ManagedBeanManager<?>)managedBeanManager, injectionManager, switchboard);
        if (injectors != null) {
            for (String injectorMCBeanName : injectors) {
                logger.debug((Object)("Adding injector dependency: " + injectorMCBeanName + " for managed bean manager: " + managedBeanManagerMCBeanName + " in unit " + unit));
                builder.addDependency((Object)injectorMCBeanName);
            }
        }
        unit.addAttachment(BeanMetaData.class + ":" + managedBeanManagerMCBeanName, (Object)builder.getBeanMetaData(), BeanMetaData.class);
    }

    private Class<?> getBeanClass(DeploymentUnit unit, ManagedBeanMetaData managedBean) throws ClassNotFoundException {
        ClassLoader cl = unit.getClassLoader();
        return Class.forName(managedBean.getManagedBeanClass(), false, cl);
    }

    private Set<String> setupInjectors(DeploymentUnit unit, ManagedBeanManager<?> managedBeanManager, InjectionManager injectionManager, Barrier switchBoard) {
        JndiEnvironmentImpl jndiEnvironment;
        if (!(managedBeanManager.getMetadata() instanceof ManagedBeanMetaDataImpl)) {
            return null;
        }
        ManagedBeanMetaDataImpl managedBeanMetaData = (ManagedBeanMetaDataImpl)managedBeanManager.getMetadata();
        if (managedBeanMetaData.getEnvironment() != null && this.hasInjectionTargets((JndiEnvironmentRefsGroup)(jndiEnvironment = new JndiEnvironmentImpl((Environment)managedBeanMetaData.getEnvironment(), unit.getClassLoader())))) {
            EEInjector eeInjector = new EEInjector((JndiEnvironmentRefsGroup)jndiEnvironment);
            injectionManager.addInjector((Injector)eeInjector);
            String injectorMCBeanName = this.getInjectorMCBeanNamePrefix(unit) + ",managedbean=" + managedBeanMetaData.getName();
            BeanMetaData injectorBMD = this.createInjectorBMD(injectorMCBeanName, eeInjector, switchBoard);
            unit.addAttachment(BeanMetaData.class + ":" + injectorMCBeanName, (Object)injectorBMD);
            return Collections.singleton(injectorMCBeanName);
        }
        return null;
    }

    private boolean hasInjectionTargets(JndiEnvironmentRefsGroup jndiEnv) {
        Collection envEntries = jndiEnv.getEntries();
        if (envEntries == null || envEntries.isEmpty()) {
            return false;
        }
        for (EnvironmentEntryType envEntry : envEntries) {
            Collection injectionTargets = envEntry.getInjectionTargets();
            if (injectionTargets == null || injectionTargets.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private BeanMetaData createInjectorBMD(String injectorMCBeanName, EEInjector injector, Barrier barrier) {
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)injectorMCBeanName, (String)injector.getClass().getName());
        builder.setConstructorValue((Object)injector);
        builder.addDependency((Object)barrier.getId());
        return builder.getBeanMetaData();
    }

    private String getInjectorMCBeanNamePrefix(DeploymentUnit unit) {
        StringBuilder sb = new StringBuilder("jboss-injector:");
        DeploymentUnit topLevelUnit = unit.isTopLevel() ? unit : unit.getTopLevel();
        sb.append("topLevelUnit=");
        sb.append(topLevelUnit.getSimpleName());
        sb.append(",");
        sb.append("unit=");
        sb.append(unit.getSimpleName());
        return sb.toString();
    }
}

