/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.asintegration.jboss5;

import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeKey;

class FakeComponentUnit {
    VFSDeploymentUnit parent;
    BeanMetaData bmd;
    ScopeKey scope;
    ScopeKey mutableScope;

    FakeComponentUnit(VFSDeploymentUnit parent, BeanMetaData bmd) {
        this.parent = parent;
        this.bmd = bmd;
    }

    ScopeKey getScope() {
        if (this.scope == null) {
            ScopeKey key = this.parent.getScope().clone();
            key.removeScopeLevel(CommonLevels.INSTANCE);
            key.addScope(CommonLevels.INSTANCE, (Object)this.bmd.getName());
        }
        return this.scope;
    }

    ScopeKey getMutableScope() {
        if (this.mutableScope == null) {
            this.mutableScope = new ScopeKey();
            this.mutableScope.addScope(CommonLevels.INSTANCE, (Object)this.bmd.getName());
        }
        return this.mutableScope;
    }

    ClassLoader getClassLoader() {
        return this.parent.getClassLoader();
    }

    String getName() {
        return this.bmd.getName();
    }

    BeanMetaData getBeanMetaData() {
        return this.bmd;
    }

    void cleanup() {
        ScopeKey scope;
        MutableMetaDataRepository repository = null;
        for (VFSDeploymentUnit unit = this.parent; repository == null && unit != null; unit = unit.getParent()) {
            repository = (MutableMetaDataRepository)unit.getAttachment(MutableMetaDataRepository.class);
        }
        if (repository == null) {
            return;
        }
        try {
            scope = this.getScope();
            repository.removeMetaDataRetrieval(scope);
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        try {
            scope = this.getMutableScope();
            repository.removeMetaDataRetrieval(scope);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

