/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.ejb3.BeanContext;
import org.jboss.injection.Injector;
import org.jboss.injection.PojoInjector;
import org.jboss.logging.Logger;

public class EntityManagerFactoryMethodInjector
implements Injector,
PojoInjector {
    private static final Logger log = Logger.getLogger(EntityManagerFactoryMethodInjector.class);
    private Method setMethod;
    private Object factory;

    public EntityManagerFactoryMethodInjector(Method setMethod, Object factory) {
        this.setMethod = setMethod;
        setMethod.setAccessible(true);
        this.factory = factory;
    }

    @Override
    public void inject(BeanContext ctx) {
        this.inject(ctx, ctx.getInstance());
    }

    @Override
    public void inject(BeanContext ctx, Object instance) {
        this.inject(instance);
    }

    @Override
    public void inject(Object instance) {
        try {
            Object[] args = new Object[]{this.factory};
            this.setMethod.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed in setting EntityManager on setter method: " + this.setMethod.toString());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public Class getInjectionClass() {
        return this.setMethod.getParameterTypes()[0];
    }
}

