/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.core.resolvers;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.resolvers.spi.EjbReference;
import org.jboss.ejb3.common.resolvers.spi.EjbReferenceResolver;
import org.jboss.ejb3.common.resolvers.spi.EjbReferenceResolverBase;
import org.jboss.ejb3.common.resolvers.spi.UnresolvableReferenceException;
import org.jboss.metadata.ejb.jboss.JBossMetaData;

public class ScopedEJBReferenceResolver
extends EjbReferenceResolverBase
implements EjbReferenceResolver {
    protected String find(DeploymentUnit du, EjbReference reference) {
        JBossMetaData metadata = this.getMetaData(du);
        if (metadata == null) {
            return null;
        }
        return this.getMatch(reference, metadata, du.getClassLoader());
    }

    @Deprecated
    protected String findWithin(DeploymentUnit du, DeploymentUnit excludeChild, EjbReference reference) {
        DeploymentUnit parent;
        String jndiName = this.find(du, reference);
        if (jndiName != null) {
            return jndiName;
        }
        List children = du.getChildren();
        if (children != null) {
            for (DeploymentUnit child : children) {
                if (child == excludeChild || (jndiName = this.findWithin(child, null, reference)) == null) continue;
                return jndiName;
            }
        }
        if ((parent = du.getParent()) != null) {
            return this.findWithin(parent, du, reference);
        }
        return null;
    }

    public String resolveEjb(DeploymentUnit du, EjbReference reference) throws UnresolvableReferenceException {
        String jndiName = this.resolveWithinDeploymentUnit(du, new HashSet<DeploymentUnit>(), reference);
        if (jndiName == null) {
            throw new UnresolvableReferenceException("Could not resolve reference " + reference + " in " + du);
        }
        return jndiName;
    }

    protected String resolveWithinDeploymentUnit(DeploymentUnit du, Collection<DeploymentUnit> alreadyScannedDUs, EjbReference reference) {
        List children;
        String jndiName = this.find(du, reference);
        if (jndiName != null) {
            return jndiName;
        }
        if (alreadyScannedDUs == null) {
            alreadyScannedDUs = new HashSet<DeploymentUnit>();
        }
        if ((children = du.getChildren()) != null) {
            for (DeploymentUnit child : children) {
                if (alreadyScannedDUs.contains(child)) continue;
                jndiName = this.resolveWithinDeploymentUnit(child, alreadyScannedDUs, reference);
                if (jndiName != null) {
                    return jndiName;
                }
                alreadyScannedDUs.add(child);
            }
        }
        alreadyScannedDUs.add(du);
        DeploymentUnit parent = du.getParent();
        if (parent != null) {
            return this.resolveWithinDeploymentUnit(parent, alreadyScannedDUs, reference);
        }
        return null;
    }
}

