/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.VersionInfo;

public class LibraryInfo {
    private String name;
    private VersionInfo version;
    private String localePrefix;
    private ResourceHelper helper;
    private String path;

    LibraryInfo(String name, VersionInfo version, String localePrefix, ResourceHelper helper) {
        this.name = name;
        this.version = version;
        this.localePrefix = localePrefix;
        this.helper = helper;
        this.initPath();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        LibraryInfo other = (LibraryInfo)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!(this.version == other.version || this.version != null && this.version.equals(other.version))) {
            return false;
        }
        if (this.localePrefix == null ? other.localePrefix != null : !this.localePrefix.equals(other.localePrefix)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 37 * hash + (this.version != null ? this.version.hashCode() : 0);
        hash = 37 * hash + (this.localePrefix != null ? this.localePrefix.hashCode() : 0);
        hash = 37 * hash + (this.path != null ? this.path.hashCode() : 0);
        return hash;
    }

    public String getName() {
        return this.name;
    }

    public VersionInfo getVersion() {
        return this.version;
    }

    public ResourceHelper getHelper() {
        return this.helper;
    }

    public String getPath() {
        return this.path;
    }

    public String getLocalePrefix() {
        return this.localePrefix;
    }

    public String toString() {
        return "LibraryInfo{name='" + this.name + '\'' + ", version=" + (this.version != null ? this.version : "NONE") + '\'' + ", localePrefix='" + (this.localePrefix != null ? this.localePrefix : "NONE") + '\'' + ", path='" + this.path + '\'' + '}';
    }

    private void initPath() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.helper.getBaseResourcePath());
        if (this.localePrefix != null) {
            sb.append('/').append(this.localePrefix);
        }
        sb.append('/').append(this.name);
        if (this.version != null) {
            sb.append('/').append(this.version.getVersion());
        }
        this.path = sb.toString();
    }
}

