/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.instantiator;

import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.ejb3.instantiator.impl.Ejb31SpecBeanInstantiator;
import org.jboss.ejb3.instantiator.spi.BeanInstantiationException;
import org.jboss.ejb3.instantiator.spi.InvalidConstructionParamsException;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.integration.deployer.env.helpers.BootstrapBean;
import org.jboss.weld.manager.api.WeldManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jsr299BeanInstantiator
extends Ejb31SpecBeanInstantiator {
    private BootstrapBean bootstrapBean;
    private String bdaId;
    private JBossEnterpriseBeanMetaData enterpriseBeanMetaData;
    private AtomicReference<WeldManager> weldManagerRef = new AtomicReference();

    public Jsr299BeanInstantiator(JBossEnterpriseBeanMetaData enterpriseBeanMetaData) {
        if (enterpriseBeanMetaData == null) {
            throw new RuntimeException("EnterpriseBeanMetadata cannot be null");
        }
        this.enterpriseBeanMetaData = enterpriseBeanMetaData;
    }

    public void setBdaId(String bdaId) {
        this.bdaId = bdaId;
    }

    public void setBootstrapBean(BootstrapBean bootstrapBean) {
        this.bootstrapBean = bootstrapBean;
    }

    public <T> T create(Class<T> clazz, Object[] objects) throws IllegalArgumentException, InvalidConstructionParamsException, BeanInstantiationException {
        WeldManager weldManager = this.getWeldManager();
        EjbDescriptor ejbDescriptor = weldManager.getEjbDescriptor(this.enterpriseBeanMetaData.getEjbName());
        if (ejbDescriptor.getBeanClass().equals(clazz)) {
            SessionBean bean = (SessionBean)weldManager.getBean(ejbDescriptor);
            InjectionTarget injectionTarget = weldManager.createInjectionTarget(ejbDescriptor);
            CreationalContext creationalContext = weldManager.createCreationalContext((Contextual)bean);
            Object instance = injectionTarget.produce(creationalContext);
            return (T)instance;
        }
        return (T)super.create(clazz, objects);
    }

    private WeldManager getWeldManager() {
        WeldManager weldManager = this.weldManagerRef.get();
        if (weldManager == null) {
            weldManager = this.locateWeldManager();
        }
        this.weldManagerRef.compareAndSet(null, weldManager);
        return weldManager;
    }

    private WeldManager locateWeldManager() {
        BeanDeploymentArchive foundBeanDeploymentArchive = null;
        for (BeanDeploymentArchive beanDeploymentArchive : this.bootstrapBean.getDeployment().getBeanDeploymentArchives()) {
            if (!beanDeploymentArchive.getId().equals(this.bdaId)) continue;
            foundBeanDeploymentArchive = beanDeploymentArchive;
        }
        if (foundBeanDeploymentArchive == null) {
            throw new IllegalStateException("Cannot find BeanManager for BeanDeploymentArchive with id=" + this.bdaId);
        }
        return this.bootstrapBean.getBootstrap().getManager(foundBeanDeploymentArchive);
    }

    public void uninstall() {
        this.weldManagerRef.set(null);
        this.enterpriseBeanMetaData = null;
    }
}

