/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.injection;

import org.jboss.beans.metadata.api.model.InjectOption;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.injection.manager.spi.InjectionManager;
import org.jboss.injection.manager.spi.Injector;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.weld.integration.deployer.DeployersUtils;
import org.jboss.weld.integration.injection.Jsr299InterceptorInjector;
import org.jboss.weld.integration.injection.Jsr299SimpleNonContextualInjector;
import org.jboss.weld.integration.util.IdFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jsr299InjectorDeployer
extends AbstractSimpleRealDeployer<InjectionManager> {
    private KernelController kernelController;

    public Jsr299InjectorDeployer() {
        super(InjectionManager.class);
        this.setStage(DeploymentStages.REAL);
        this.setWantComponents(true);
        this.setOutput(InjectionManager.class);
    }

    public void setKernelController(KernelController kernelController) {
        this.kernelController = kernelController;
    }

    public void deploy(DeploymentUnit unit, InjectionManager deployment) throws DeploymentException {
        if (this.isCDIDeployment(unit)) {
            String bdaId = IdFactory.getIdFromClassLoader(unit.getClassLoader());
            try {
                Object injector = null;
                BeanMetaDataBuilder builder = null;
                if (!unit.isComponent()) {
                    injector = new Jsr299SimpleNonContextualInjector(bdaId);
                    builder = BeanMetaDataBuilder.createBuilder((String)this.getJsr299InjectorMcBeanName(unit), (String)Jsr299SimpleNonContextualInjector.class.getName());
                } else {
                    JBossEnterpriseBeanMetaData enterpriseBeanMetaData = (JBossEnterpriseBeanMetaData)unit.getAttachment(JBossEnterpriseBeanMetaData.class);
                    if (enterpriseBeanMetaData != null && enterpriseBeanMetaData.getJBossMetaData().isEJB3x()) {
                        injector = new Jsr299InterceptorInjector(bdaId, enterpriseBeanMetaData);
                        builder = BeanMetaDataBuilder.createBuilder((String)this.getJsr299InjectorMcBeanName(unit), (String)Jsr299InterceptorInjector.class.getName());
                    }
                }
                if (injector != null) {
                    AbstractInjectionValueMetaData injectionValueMetaData = new AbstractInjectionValueMetaData((Object)DeployersUtils.getBootstrapBeanName(unit));
                    injectionValueMetaData.setInjectionOption(InjectOption.CALLBACK);
                    builder.addPropertyMetaData("bootstrapBean", (ValueMetaData)injectionValueMetaData);
                    builder.addUninstall("release");
                    this.kernelController.install(builder.getBeanMetaData(), injector);
                    deployment.addInjector((Injector)injector);
                }
            }
            catch (Throwable throwable) {
                throw new DeploymentException(throwable);
            }
        }
    }

    private boolean isCDIDeployment(DeploymentUnit unit) {
        return unit.getAttachment("WELD_FILES") != null;
    }

    public void undeploy(DeploymentUnit unit, InjectionManager deployment) {
        if (this.isCDIDeployment(unit) && this.hasInjector(unit)) {
            this.kernelController.uninstall((Object)this.getJsr299InjectorMcBeanName(unit));
        }
    }

    private String getJsr299InjectorMcBeanName(DeploymentUnit deploymentUnit) {
        if (!deploymentUnit.isComponent()) {
            return deploymentUnit.getName() + "_Jsr299BeanInjector";
        }
        return deploymentUnit.getParent().getName() + "/" + deploymentUnit.getName() + "_Jsr299Injector";
    }

    private boolean hasInjector(DeploymentUnit deploymentUnit) {
        if (!deploymentUnit.isComponent()) {
            return true;
        }
        JBossEnterpriseBeanMetaData enterpriseBeanMetaData = (JBossEnterpriseBeanMetaData)deploymentUnit.getAttachment(JBossEnterpriseBeanMetaData.class);
        return enterpriseBeanMetaData != null && enterpriseBeanMetaData.getJBossMetaData().isEJB3x();
    }
}

