/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.security.auth.callback.MapCallback;

public class DigestCallbackHandler
implements CallbackHandler {
    private String username;
    private String nonce;
    private String nc;
    private String cnonce;
    private String qop;
    private String realm;
    private String md5a2;

    DigestCallbackHandler(String username, String nonce, String nc, String cnonce, String qop, String realm, String md5a2) {
        this.username = username;
        this.nonce = nonce;
        this.nc = nc;
        this.cnonce = cnonce;
        this.qop = qop;
        this.realm = realm;
        this.md5a2 = md5a2;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        boolean foundCallback = false;
        Callback firstUnknown = null;
        int count = callbacks != null ? callbacks.length : 0;
        for (int n = 0; n < count; ++n) {
            Callback c = callbacks[n];
            if (c instanceof MapCallback) {
                MapCallback mc = (MapCallback)c;
                mc.setInfo("username", (Object)this.username);
                mc.setInfo("cnonce", (Object)this.cnonce);
                mc.setInfo("nonce", (Object)this.nonce);
                mc.setInfo("nc", (Object)this.nc);
                mc.setInfo("qop", (Object)this.qop);
                mc.setInfo("realm", (Object)this.realm);
                mc.setInfo("a2hash", (Object)this.md5a2);
                foundCallback = true;
                continue;
            }
            if (firstUnknown != null) continue;
            firstUnknown = c;
        }
        if (!foundCallback) {
            throw new UnsupportedCallbackException(firstUnknown, "Unrecognized Callback");
        }
    }
}

