/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jpa.impl.deployment;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.hibernate.ejb.HibernatePersistence;
import org.jboss.logging.Logger;
import org.jboss.metadata.jpa.spec.PersistenceUnitMetaData;
import org.jboss.metadata.jpa.spec.SharedCacheMode;
import org.jboss.metadata.jpa.spec.TransactionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    private static final Logger log = Logger.getLogger(PersistenceUnitInfoImpl.class);
    private String entityManagerName;
    private DataSource jtaDataSource;
    private DataSource nonJtaDataSource;
    private List<String> mappingFileNames;
    private List<URL> jarFiles;
    private List<String> entityclassNames;
    private Properties properties;
    private ClassLoader classLoader;
    private String persistenceProviderClassName;
    private PersistenceUnitTransactionType transactionType;
    private URL persistenceUnitRootUrl;
    private boolean excludeClasses;
    private ValidationMode validationMode;
    private String persistenceXMLSchemaVersion;
    private javax.persistence.SharedCacheMode sharedCacheMode;

    public PersistenceUnitInfoImpl() {
    }

    public PersistenceUnitInfoImpl(PersistenceUnitMetaData metaData, Properties props, ClassLoader classLoader, URL persistenceUnitRootUrl, List<URL> jarFiles, Context ctx) throws NamingException {
        log.debug((Object)("Using class loader " + classLoader));
        this.setClassLoader(classLoader);
        this.setJarFiles(jarFiles);
        this.setPersistenceProviderClassName(HibernatePersistence.class.getName());
        log.debug((Object)"Found persistence.xml file in EJB3 jar");
        this.setManagedClassnames(PersistenceUnitInfoImpl.safeList(metaData.getClasses()));
        this.setPersistenceUnitName(metaData.getName());
        this.setMappingFileNames(PersistenceUnitInfoImpl.safeList(metaData.getMappingFiles()));
        this.setExcludeUnlistedClasses(metaData.isExcludeUnlistedClasses());
        this.setPersistenceUnitRootUrl(persistenceUnitRootUrl);
        PersistenceUnitTransactionType transactionType = PersistenceUnitInfoImpl.getJPATransactionType(metaData);
        this.setTransactionType(transactionType);
        this.setValidationMode(this.convertToValidationMode(metaData.getValidationMode()));
        this.setPersistenceXMLSchemaVersion(null);
        this.setSharedCacheMode(this.getSharedCacheMode(metaData.getSharedCacheMode()));
        if (metaData.getProvider() != null) {
            this.setPersistenceProviderClassName(metaData.getProvider());
        }
        if (metaData.getJtaDataSource() != null) {
            this.setJtaDataSource((DataSource)ctx.lookup(metaData.getJtaDataSource()));
        } else if (transactionType == PersistenceUnitTransactionType.JTA) {
            throw new RuntimeException("Specification violation [EJB3 JPA 6.2.1.2] - You have not defined a jta-data-source for a JTA enabled persistence context named: " + metaData.getName());
        }
        if (metaData.getNonJtaDataSource() != null) {
            this.setNonJtaDataSource((DataSource)ctx.lookup(metaData.getNonJtaDataSource()));
        } else if (transactionType == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            throw new RuntimeException("Specification violation [EJB3 JPA 6.2.1.2] - You have not defined a non-jta-data-source for a RESOURCE_LOCAL enabled persistence context named: " + metaData.getName());
        }
        props.putAll(PersistenceUnitInfoImpl.getProperties(metaData));
        this.setProperties(props);
        if (this.getPersistenceUnitName() == null) {
            throw new RuntimeException("you must specify a name in persistence.xml");
        }
    }

    private javax.persistence.SharedCacheMode getSharedCacheMode(SharedCacheMode mode) {
        if (mode == null) {
            return null;
        }
        switch (mode) {
            case ALL: {
                return javax.persistence.SharedCacheMode.ALL;
            }
            case DISABLE_SELECTIVE: {
                return javax.persistence.SharedCacheMode.DISABLE_SELECTIVE;
            }
            case ENABLE_SELECTIVE: {
                return javax.persistence.SharedCacheMode.ENABLE_SELECTIVE;
            }
            case NONE: {
                return javax.persistence.SharedCacheMode.NONE;
            }
            case UNSPECIFIED: {
                return javax.persistence.SharedCacheMode.UNSPECIFIED;
            }
        }
        return null;
    }

    private ValidationMode convertToValidationMode(org.jboss.metadata.jpa.spec.ValidationMode validationMode) {
        if (validationMode == null) {
            return null;
        }
        switch (validationMode) {
            case AUTO: {
                return ValidationMode.AUTO;
            }
            case CALLBACK: {
                return ValidationMode.CALLBACK;
            }
            case NONE: {
                return ValidationMode.NONE;
            }
        }
        return null;
    }

    public void addTransformer(ClassTransformer transformer) {
    }

    private static List<String> safeList(Set<String> set) {
        return set == null || set.isEmpty() ? Collections.emptyList() : new ArrayList<String>(set);
    }

    public ClassLoader getNewTempClassLoader() {
        return null;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    public void setPersistenceProviderClassName(String persistenceProviderClassName) {
        this.persistenceProviderClassName = persistenceProviderClassName;
    }

    public String getPersistenceUnitName() {
        return this.entityManagerName;
    }

    public void setPersistenceUnitName(String entityManagerName) {
        this.entityManagerName = entityManagerName;
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public void setJtaDataSource(DataSource jtaDataSource) {
        this.jtaDataSource = jtaDataSource;
    }

    protected static PersistenceUnitTransactionType getJPATransactionType(PersistenceUnitMetaData metaData) {
        TransactionType type = metaData.getTransactionType();
        if (type == TransactionType.RESOURCE_LOCAL) {
            return PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        return PersistenceUnitTransactionType.JTA;
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public void setNonJtaDataSource(DataSource nonJtaDataSource) {
        this.nonJtaDataSource = nonJtaDataSource;
    }

    public List<String> getMappingFileNames() {
        return this.mappingFileNames;
    }

    public void setMappingFileNames(List<String> mappingFileNames) {
        this.mappingFileNames = mappingFileNames;
    }

    public List<URL> getJarFileUrls() {
        return this.jarFiles;
    }

    public void setJarFiles(List<URL> jarFiles) {
        assert (jarFiles != null) : "jarFiles is null";
        this.jarFiles = jarFiles;
    }

    public List<String> getManagedClassNames() {
        return this.entityclassNames;
    }

    public void setManagedClassnames(List<String> entityclassNames) {
        this.entityclassNames = entityclassNames;
    }

    public Properties getProperties() {
        return this.properties;
    }

    protected static Map<String, String> getProperties(PersistenceUnitMetaData metaData) {
        Map<String, String> properties = metaData.getProperties();
        return properties != null ? properties : Collections.emptyMap();
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitRootUrl;
    }

    public void setPersistenceUnitRootUrl(URL persistenceUnitRootUrl) {
        this.persistenceUnitRootUrl = persistenceUnitRootUrl;
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeClasses;
    }

    public void setExcludeUnlistedClasses(boolean excludeClasses) {
        this.excludeClasses = excludeClasses;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public javax.persistence.SharedCacheMode getSharedCacheMode() {
        return this.sharedCacheMode;
    }

    public void setSharedCacheMode(javax.persistence.SharedCacheMode sharedCacheMode) {
        this.sharedCacheMode = sharedCacheMode;
    }

    public String getPersistenceXMLSchemaVersion() {
        return this.persistenceXMLSchemaVersion;
    }

    public String PersistenceXMLSchemaVersion() {
        return this.persistenceXMLSchemaVersion;
    }

    public void setPersistenceXMLSchemaVersion(String persistenceXMLSchemaVersion) {
        this.persistenceXMLSchemaVersion = persistenceXMLSchemaVersion;
    }
}

