/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.shared_impl.renderkit.html.HTML;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.shared_impl.renderkit.html.util.ResourceUtils;

public class HtmlBodyRendererBase
extends HtmlRenderer {
    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        HtmlRendererUtils.decodeClientBehaviors(context, component);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeBegin(facesContext, component);
        ResponseWriter writer = facesContext.getResponseWriter();
        Map behaviors = null;
        if (component instanceof ClientBehaviorHolder && JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext())) {
            behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
            if (!behaviors.isEmpty()) {
                ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
            }
            writer.startElement("body", component);
            HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
            HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, component, behaviors);
            HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onload", component, "load", behaviors, "onload");
            HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onunload", component, "unload", behaviors, "onunload");
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.BODY_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
        } else {
            writer.startElement("body", component);
            HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.BODY_PASSTHROUGH_ATTRIBUTES);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEnd(facesContext, component);
        ResponseWriter writer = facesContext.getResponseWriter();
        UIViewRoot root = facesContext.getViewRoot();
        for (UIComponent child : root.getComponentResources(facesContext, "body")) {
            child.encodeAll(facesContext);
        }
        if (facesContext.isProjectStage(ProjectStage.Development)) {
            HtmlRendererUtils.renderUnhandledFacesMessages(facesContext);
        }
        writer.endElement("body");
    }
}

