/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
import org.jboss.profileservice.management.PlatformMBeanIDC;
import org.jboss.system.ServiceController;

public class PlatformMBeanKernelRegistryPlugin
implements KernelRegistryPlugin {
    private Map<String, KernelRegistryEntry> mbeans = new HashMap<String, KernelRegistryEntry>();
    private ServiceController serviceController;
    private MBeanServer mbeanServer;

    public ServiceController getServiceController() {
        return this.serviceController;
    }

    public void setServiceController(ServiceController serviceController) {
        this.serviceController = serviceController;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public KernelRegistryEntry getEntry(Object name) {
        String key;
        ObjectName oname = null;
        if (name instanceof ObjectName) {
            oname = (ObjectName)ObjectName.class.cast(name);
            key = oname.getCanonicalName();
        } else {
            key = name.toString();
        }
        KernelRegistryEntry entry = this.mbeans.get(key);
        if (entry == null && oname != null) {
            System.out.println("Searching for MBean: " + oname);
            try {
                ObjectInstance oi = this.mbeanServer.getObjectInstance(oname);
                System.out.println("Found " + oname + ", " + oi.getClassName());
            }
            catch (InstanceNotFoundException e) {
                e.printStackTrace();
            }
        }
        return entry;
    }

    public void start() throws Throwable {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ClassLoadingMXBean clmbean = ManagementFactory.getClassLoadingMXBean();
        ObjectName clname = new ObjectName("java.lang:type=ClassLoading");
        PlatformMBeanIDC clidc = new PlatformMBeanIDC(server, clname, clmbean);
        this.mbeans.put(clname.getCanonicalName(), (KernelRegistryEntry)clidc);
        CompilationMXBean cmbean = ManagementFactory.getCompilationMXBean();
        ObjectName cmname = new ObjectName("java.lang:type=Compilation");
        PlatformMBeanIDC cmidc = new PlatformMBeanIDC(server, cmname, cmbean);
        this.mbeans.put(cmname.getCanonicalName(), (KernelRegistryEntry)cmidc);
        List<GarbageCollectorMXBean> gcbeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean mbean : gcbeans) {
            String name = mbean.getName();
            ObjectName oname = new ObjectName("java.lang:type=GarbageCollector" + name);
            String cname = oname.getCanonicalName();
            PlatformMBeanIDC gcidc = new PlatformMBeanIDC(server, oname, mbean);
            this.mbeans.put(cname, (KernelRegistryEntry)gcidc);
        }
        List<MemoryManagerMXBean> mmbeans = ManagementFactory.getMemoryManagerMXBeans();
        for (MemoryManagerMXBean mbean : mmbeans) {
            String name = mbean.getName();
            ObjectName oname = new ObjectName("java.lang:type=MemoryManager" + name);
            String cname = oname.getCanonicalName();
            PlatformMBeanIDC mmidc = new PlatformMBeanIDC(server, oname, mbean);
            this.mbeans.put(cname, (KernelRegistryEntry)mmidc);
        }
        MemoryMXBean mxbean = ManagementFactory.getMemoryMXBean();
        ObjectName mxname = new ObjectName("java.lang:type=Memory");
        PlatformMBeanIDC mxidc = new PlatformMBeanIDC(server, mxname, mxbean);
        this.mbeans.put(mxname.getCanonicalName(), (KernelRegistryEntry)mxidc);
        List<MemoryPoolMXBean> mpbeans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean mbean : mpbeans) {
            String name = mbean.getName();
            ObjectName oname = new ObjectName("java.lang:type=MemoryPool" + name);
            String cname = oname.getCanonicalName();
            PlatformMBeanIDC mpidc = new PlatformMBeanIDC(server, oname, mbean);
            this.mbeans.put(cname, (KernelRegistryEntry)mpidc);
        }
        OperatingSystemMXBean osbean = ManagementFactory.getOperatingSystemMXBean();
        ObjectName osname = new ObjectName("java.lang:type=OperatingSystem");
        PlatformMBeanIDC osidc = new PlatformMBeanIDC(server, osname, osbean);
        this.mbeans.put(osname.getCanonicalName(), (KernelRegistryEntry)osidc);
        RuntimeMXBean rtbean = ManagementFactory.getRuntimeMXBean();
        ObjectName rtname = new ObjectName("java.lang:type=Runtime");
        PlatformMBeanIDC rtidc = new PlatformMBeanIDC(server, rtname, rtbean);
        this.mbeans.put(rtname.getCanonicalName(), (KernelRegistryEntry)rtidc);
        ThreadMXBean tbean = ManagementFactory.getThreadMXBean();
        ObjectName tname = new ObjectName("java.lang:type=Threading");
        PlatformMBeanIDC tidc = new PlatformMBeanIDC(server, tname, tbean);
        this.mbeans.put(tname.getCanonicalName(), (KernelRegistryEntry)tidc);
    }

    public void stop() {
    }
}

