/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.finalcontainers;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import org.jboss.serial.finalcontainers.FinalContainer;

public class DoubleContainer
extends FinalContainer {
    double value;

    public DoubleContainer(double value) {
        this.value = value;
    }

    public DoubleContainer() {
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleContainer that = (DoubleContainer)o;
        return Double.compare(that.value, this.value) == 0;
    }

    public int hashCode() {
        long temp = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
        return (int)(temp ^ temp >>> 32);
    }

    public void writeMyself(DataOutput output) throws IOException {
        output.writeDouble(this.value);
    }

    public void readMyself(DataInput input) throws IOException {
        this.value = input.readDouble();
    }

    public void setPrimitive(Object obj, Field field) throws IllegalAccessException {
        field.setDouble(obj, this.value);
    }
}

