/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.attr;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.attr.BagAttribute;
import org.jboss.security.xacml.sunxacml.cond.Evaluatable;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.sunxacml.ctx.Status;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeDesignator
implements Evaluatable {
    public static final int SUBJECT_TARGET = 0;
    public static final int RESOURCE_TARGET = 1;
    public static final int ACTION_TARGET = 2;
    public static final int ENVIRONMENT_TARGET = 3;
    public static final String SUBJECT_CATEGORY_DEFAULT = "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject";
    private static final String[] targetTypes = new String[]{"Subject", "Resource", "Action", "Environment"};
    private int target;
    private URI type;
    private URI id;
    private URI issuer;
    private boolean mustBePresent;
    private URI subjectCategory;
    private static final Logger logger = Logger.getLogger(AttributeDesignator.class.getName());

    public AttributeDesignator(int target, URI type, URI id, boolean mustBePresent) {
        this(target, type, id, mustBePresent, null);
    }

    public AttributeDesignator(int target, URI type, URI id, boolean mustBePresent, URI issuer) throws IllegalArgumentException {
        if (target != 0 && target != 1 && target != 2 && target != 3) {
            throw new IllegalArgumentException("Input target is not a validvalue");
        }
        this.target = target;
        this.type = type;
        this.id = id;
        this.mustBePresent = mustBePresent;
        this.issuer = issuer;
        this.subjectCategory = null;
    }

    public void setSubjectCategory(URI category) {
        if (this.target == 0) {
            this.subjectCategory = category;
        }
    }

    public static AttributeDesignator getInstance(Node root, int target) throws ParsingException {
        return AttributeDesignator.getInstance(root, target, new PolicyMetaData());
    }

    public static AttributeDesignator getInstance(Node root, int target, PolicyMetaData metaData) throws ParsingException {
        URI type = null;
        URI id = null;
        URI issuer = null;
        boolean mustBePresent = false;
        URI subjectCategory = null;
        NamedNodeMap attrs = root.getAttributes();
        try {
            Node attributeIdNode = attrs.getNamedItem("AttributeId");
            if (attributeIdNode == null) {
                throw new ParsingException("Required AttributeId missing in AttributeDesignator ->" + root.getNodeName());
            }
            id = new URI(attributeIdNode.getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Required AttributeId missing in AttributeDesignator", e);
        }
        try {
            Node dataTypeNode = attrs.getNamedItem("DataType");
            if (dataTypeNode == null) {
                throw new IllegalStateException("Required DataType missing in AttributeDesignator ->" + root.getNodeName());
            }
            type = new URI(dataTypeNode.getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Required DataType missing in AttributeDesignator", e);
        }
        try {
            Node node = attrs.getNamedItem("Issuer");
            if (node != null) {
                issuer = new URI(node.getNodeValue());
            }
            if (target == 0) {
                Node scnode = attrs.getNamedItem("SubjectCategory");
                subjectCategory = scnode != null ? new URI(scnode.getNodeValue()) : new URI(SUBJECT_CATEGORY_DEFAULT);
            }
            if ((node = attrs.getNamedItem("MustBePresent")) != null && node.getNodeValue().equals("true")) {
                mustBePresent = true;
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing AttributeDesignator optional attributes", e);
        }
        AttributeDesignator ad = new AttributeDesignator(target, type, id, mustBePresent, issuer);
        ad.setSubjectCategory(subjectCategory);
        return ad;
    }

    public int getDesignatorType() {
        return this.target;
    }

    public URI getType() {
        return this.type;
    }

    public URI getId() {
        return this.id;
    }

    public URI getCategory() {
        return this.subjectCategory;
    }

    public URI getIssuer() {
        return this.issuer;
    }

    public boolean mustBePresent() {
        return this.mustBePresent;
    }

    public boolean returnsBag() {
        return true;
    }

    public boolean evaluatesToBag() {
        return true;
    }

    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public EvaluationResult evaluate(EvaluationCtx context) {
        EvaluationResult result = null;
        switch (this.target) {
            case 0: {
                result = context.getSubjectAttribute(this.type, this.id, this.issuer, this.subjectCategory);
                break;
            }
            case 1: {
                result = context.getResourceAttribute(this.type, this.id, this.issuer);
                break;
            }
            case 2: {
                result = context.getActionAttribute(this.type, this.id, this.issuer);
                break;
            }
            case 3: {
                result = context.getEnvironmentAttribute(this.type, this.id, this.issuer);
            }
        }
        if (result.indeterminate()) {
            return result;
        }
        BagAttribute bag = (BagAttribute)result.getAttributeValue();
        if (bag.isEmpty() && this.mustBePresent) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("AttributeDesignator failed to resolve a value for a required attribute: " + this.id.toString());
            }
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
            String message = "Couldn't find " + targetTypes[this.target] + "AttributeDesignator attribute";
            return new EvaluationResult(new Status(code, message));
        }
        return result;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        String tag = "<" + targetTypes[this.target] + "AttributeDesignator";
        if (this.target == 0 && this.subjectCategory != null) {
            tag = tag + " SubjectCategory=\"" + this.subjectCategory.toString() + "\"";
        }
        tag = tag + " AttributeId=\"" + this.id.toString() + "\"";
        tag = tag + " DataType=\"" + this.type.toString() + "\"";
        if (this.issuer != null) {
            tag = tag + " Issuer=\"" + this.issuer.toString() + "\"";
        }
        if (this.mustBePresent) {
            tag = tag + " MustBePresent=\"true\"";
        }
        tag = tag + "/>";
        out.println(indent + tag);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.encode(baos);
        return baos.toString();
    }
}

