/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.process.chain.ejb.jboss;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.process.ProcessingException;
import org.jboss.metadata.process.chain.ProcessorChain;
import org.jboss.metadata.process.processor.JBossMetaDataProcessor;

public class JBossMetaDataProcessorChain<T extends JBossMetaData>
implements ProcessorChain<T> {
    private static final Logger log = Logger.getLogger(JBossMetaDataProcessorChain.class);
    private List<JBossMetaDataProcessor<T>> processors;

    public JBossMetaDataProcessorChain() {
        this.setProcessors(new ArrayList<JBossMetaDataProcessor<T>>());
    }

    public JBossMetaDataProcessorChain(List<JBossMetaDataProcessor<T>> initialProcessors) {
        this.setProcessors(initialProcessors);
    }

    @Override
    public void addProcessor(JBossMetaDataProcessor<T> processor) {
        assert (processor != null) : "Specified processor was null";
        this._getProcessors().add(processor);
        log.debug((Object)("Added Processor " + processor + " to Chain " + this));
    }

    @Override
    public List<JBossMetaDataProcessor<T>> getProcessors() {
        List<JBossMetaDataProcessor<T>> processors = this._getProcessors();
        return Collections.unmodifiableList(processors);
    }

    @Override
    public T process(T metadata) throws ProcessingException {
        for (JBossMetaDataProcessor<T> processor : this._getProcessors()) {
            log.trace((Object)("Processing " + metadata + " on " + processor + "..."));
            metadata = processor.process(metadata);
        }
        log.debug((Object)(metadata + " has been processed on " + this));
        return metadata;
    }

    protected List<JBossMetaDataProcessor<T>> _getProcessors() {
        return this.processors;
    }

    protected void setProcessors(List<JBossMetaDataProcessor<T>> processors) {
        this.processors = processors;
    }
}

