/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.jboss.jndi.resolver.impl;

import java.util.Iterator;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.RemoteBindingMetaData;
import org.jboss.metadata.ejb.jboss.jndi.resolver.impl.AbstractJNDIPolicyBasedJNDINameResolver;
import org.jboss.metadata.ejb.jboss.jndi.resolver.spi.SessionBeanJNDINameResolver;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.KnownInterfaces;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;

public class JNDIPolicyBasedSessionBeanJNDINameResolver
extends AbstractJNDIPolicyBasedJNDINameResolver
implements SessionBeanJNDINameResolver {
    private static Logger logger = Logger.getLogger(JNDIPolicyBasedSessionBeanJNDINameResolver.class);

    public JNDIPolicyBasedSessionBeanJNDINameResolver() {
    }

    public JNDIPolicyBasedSessionBeanJNDINameResolver(DefaultJndiBindingPolicy jndibindingPolicy) {
        super(jndibindingPolicy);
    }

    @Override
    public String resolveLocalHomeJNDIName(JBossSessionBeanMetaData metadata) {
        String localHomeJndiName = metadata.getLocalHomeJndiName();
        if (localHomeJndiName != null) {
            return localHomeJndiName;
        }
        EjbDeploymentSummary ejbDeploymentSummary = this.getEjbDeploymentSummary(metadata);
        DefaultJndiBindingPolicy policy = this.getJNDIBindingPolicy(metadata);
        return policy.getJndiName(ejbDeploymentSummary, "localHome", KnownInterfaces.KnownInterfaceType.LOCAL_HOME);
    }

    @Override
    public String resolveRemoteBusinessDefaultJNDIName(JBossSessionBeanMetaData metadata) {
        String remoteBindingJndiName;
        List<RemoteBindingMetaData> bindings = metadata.getRemoteBindings();
        if (bindings != null && bindings.size() > 0 && (remoteBindingJndiName = bindings.get(0).getJndiName()) != null && remoteBindingJndiName.length() > 0) {
            return remoteBindingJndiName;
        }
        String mappedName = metadata.getMappedName();
        if (mappedName != null && mappedName.length() > 0) {
            return mappedName;
        }
        String jndiName = metadata.getJndiName();
        if (jndiName != null && jndiName.length() > 0) {
            return jndiName;
        }
        EjbDeploymentSummary ejbDeploymentSummary = this.getEjbDeploymentSummary(metadata);
        DefaultJndiBindingPolicy policy = this.getJNDIBindingPolicy(metadata);
        return policy.getJndiName(ejbDeploymentSummary, "remote", KnownInterfaces.KnownInterfaceType.BUSINESS_REMOTE);
    }

    @Override
    public String resolveRemoteHomeJNDIName(JBossSessionBeanMetaData metadata) {
        String remoteHomeJndiName = metadata.getHomeJndiName();
        if (remoteHomeJndiName != null) {
            return remoteHomeJndiName;
        }
        EjbDeploymentSummary ejbDeploymentSummary = this.getEjbDeploymentSummary(metadata);
        DefaultJndiBindingPolicy policy = this.getJNDIBindingPolicy(metadata);
        return policy.getJndiName(ejbDeploymentSummary, "home", KnownInterfaces.KnownInterfaceType.REMOTE_HOME);
    }

    @Override
    public String resolveLocalBusinessDefaultJNDIName(JBossSessionBeanMetaData metadata) {
        String localJndiName = metadata.getLocalJndiName();
        if (localJndiName != null && localJndiName.length() > 0) {
            return localJndiName;
        }
        EjbDeploymentSummary ejbDeploymentSummary = this.getEjbDeploymentSummary(metadata);
        DefaultJndiBindingPolicy policy = this.getJNDIBindingPolicy(metadata);
        return policy.getJndiName(ejbDeploymentSummary, "local", KnownInterfaces.KnownInterfaceType.BUSINESS_LOCAL);
    }

    @Override
    public String resolveJNDIName(JBossSessionBeanMetaData metadata, String interfaceName) {
        String resolvedJndiName = null;
        KnownInterfaces.KnownInterfaceType ifaceType = this.classifyInterface(metadata, interfaceName);
        if (ifaceType.equals((Object)KnownInterfaces.KnownInterfaceType.REMOTE_HOME)) {
            resolvedJndiName = this.resolveRemoteHomeJNDIName(metadata);
        } else if (ifaceType.equals((Object)KnownInterfaces.KnownInterfaceType.LOCAL_HOME)) {
            resolvedJndiName = this.resolveLocalHomeJNDIName(metadata);
        } else {
            DefaultJndiBindingPolicy policy = this.getJNDIBindingPolicy(metadata);
            resolvedJndiName = policy.getJndiName(this.getEjbDeploymentSummary(metadata), interfaceName, ifaceType);
        }
        logger.debug((Object)("Resolved JNDI Name for Interface " + interfaceName + " of type " + (Object)((Object)ifaceType) + " is " + resolvedJndiName));
        return resolvedJndiName;
    }

    protected KnownInterfaces.KnownInterfaceType classifyInterface(JBossSessionBeanMetaData metadata, String interfaceName) {
        BusinessRemotesMetaData remotes;
        KnownInterfaces.KnownInterfaceType ifaceType = KnownInterfaces.classifyInterface(interfaceName);
        if (ifaceType != KnownInterfaces.KnownInterfaceType.UNKNOWN) {
            return ifaceType;
        }
        if (metadata.getLocalHome() != null && metadata.getLocalHome().equals(interfaceName)) {
            return KnownInterfaces.KnownInterfaceType.LOCAL_HOME;
        }
        if (metadata.getHome() != null && metadata.getHome().equals(interfaceName)) {
            return KnownInterfaces.KnownInterfaceType.REMOTE_HOME;
        }
        BusinessLocalsMetaData locals = metadata.getBusinessLocals();
        if (locals != null) {
            Iterator i$ = locals.iterator();
            while (i$.hasNext()) {
                String local = (String)i$.next();
                if (!local.equals(interfaceName)) continue;
                return KnownInterfaces.KnownInterfaceType.BUSINESS_LOCAL;
            }
        }
        if (ifaceType == KnownInterfaces.KnownInterfaceType.UNKNOWN && (remotes = metadata.getBusinessRemotes()) != null) {
            Iterator i$ = remotes.iterator();
            while (i$.hasNext()) {
                String remote = (String)i$.next();
                if (!remote.equals(interfaceName)) continue;
                return KnownInterfaces.KnownInterfaceType.BUSINESS_REMOTE;
            }
        }
        return KnownInterfaces.KnownInterfaceType.UNKNOWN;
    }
}

