/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.binding.remote;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.jboss.resource.binding.remote.RemoteSerializer;
import org.jboss.resource.binding.remote.SerializableWrapper;
import org.jboss.serial.io.JBossObjectInputStream;
import org.jboss.serial.io.JBossObjectOutputStream;

public class RemoteSerializerImpl
implements RemoteSerializer,
Serializable {
    private static final RemoteSerializer serializer = new RemoteSerializerImpl();
    private static final long serialVersionUID = 6386719587282465130L;

    @Override
    public byte[] serializeToByte(Object target) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        JBossObjectOutputStream jbos = new JBossObjectOutputStream((OutputStream)oos);
        jbos.writeObject(target);
        jbos.close();
        return baos.toByteArray();
    }

    @Override
    public Object serialize(Object target) throws Exception {
        return this.shouldSerialize(target) ? this.serialize(target) : target;
    }

    @Override
    public Object deserialize(Object target) throws Exception {
        SerializableWrapper wrapper = (SerializableWrapper)target;
        byte[] payload = wrapper.getPayload();
        ByteArrayInputStream bais = new ByteArrayInputStream(payload);
        ObjectInputStream ois = new ObjectInputStream(bais);
        JBossObjectInputStream jbis = new JBossObjectInputStream((InputStream)ois);
        Object result = jbis.readObject();
        return result;
    }

    @Override
    public void serialize(Object[] targets) throws Exception {
        for (int i = 0; i < targets.length; ++i) {
            Object target = targets[i];
            targets[i] = this.serialize(target);
        }
    }

    @Override
    public boolean shouldSerialize(Object target) {
        return !(target instanceof Serializable);
    }

    static RemoteSerializer getInstance() {
        return serializer;
    }
}

