/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.sslmultiplex;

import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.socketfactory.SocketFactoryWrapper;
import org.jboss.remoting.transport.multiplex.MultiplexClientInvoker;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

public class SSLMultiplexClientInvoker
extends MultiplexClientInvoker {
    private static final Logger log = Logger.getLogger(SSLMultiplexClientInvoker.class);
    private static final boolean isTraceEnabled = log.isTraceEnabled();

    public SSLMultiplexClientInvoker(InvokerLocator locator) throws IOException {
        super(locator);
    }

    public SSLMultiplexClientInvoker(InvokerLocator locator, Map configuration) throws IOException {
        super(locator, configuration);
    }

    @Override
    protected SocketFactory createSocketFactory(Map configuration) {
        SocketFactory sf = super.createSocketFactory(configuration);
        if (SSLMultiplexClientInvoker.isCompleteSocketFactory(sf)) {
            this.socketFactory = sf;
            return sf;
        }
        SocketFactory wrapper = sf;
        try {
            SSLSocketBuilder server = new SSLSocketBuilder(configuration);
            server.setUseSSLSocketFactory(false);
            sf = server.createSSLSocketFactory();
            this.configuration.put("multiplex.SocketFactory", sf);
        }
        catch (Exception e) {
            log.error((Object)"Error creating SSL Socket Factory for client invoker.", (Throwable)e);
        }
        if (wrapper != null) {
            ((SocketFactoryWrapper)((Object)wrapper)).setSocketFactory(sf);
            this.socketFactory = wrapper;
            return wrapper;
        }
        this.socketFactory = sf;
        return sf;
    }

    @Override
    protected Socket createSocket(String address, int port, int timeout) throws IOException {
        SocketFactory sf = this.getSocketFactory();
        if (sf == null) {
            this.createSocketFactory(this.configuration);
        }
        VirtualSocket socket = new VirtualSocket(this.configuration);
        socket.connect(this.getConnectSocketAddress(), this.getBindSocketAddress(), this.timeout);
        return socket;
    }
}

